package com.bcxin.risk.sys;

import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.sys.dto.search.BusinessRequestSearchDto;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @param oid
 * @return
 * @auther Administrator
 * @date 2017/04/24 0024
 * @注意事项 </b>
 */

@Repository("businessRequestDao")
@SuppressWarnings("unchecked")
public class BusinessRequestDaoImpl extends DaoImpl<BusinessRequest> implements BusinessRequestDao {

    @Override
    public BusinessRequest findBusinessRequestByOid(Long oid){
        return selectById(oid);
    }

    @Override
    public List<BusinessRequest> findBusinessRequestList(BusinessRequestSearchDto searchDto, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        if ( searchDto.getTransaction() != null ) {
            wrapper.eq("transaction", searchDto.getTransaction());
        }

        if ( page == null ) {
            return selectList(wrapper);
        }
        return selectPage(wrapper,page).getRecords();
    }
}
