package com.bcxin.risk.surveytk;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.base.dao.BaseDao;
import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.survey.domain.Task;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @aothor hzp
 */
@Repository("taskDao")
@SuppressWarnings("unchecked")
public class TaskDaoImpl extends DaoImpl<Task> implements TaskDao {

    @Autowired
    private BaseDao baseDao;

    @Override
    public Task findSurveyTaskByActivity(Activity activity){
        List<Criterion> criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq("activity", activity));
        criterionList.add(Restrictions.eq("taskType", DictConst.TASKTYPE_SURVEY));
        List<Task> list = baseDao.findByCriterion(Task.class, criterionList);
        if(CollectionUtil.isNotEmpty(list) ) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public int countTaskByTaskStatus(String key, Long comId) {

        String sql = "SELECT a.oid FROM risk_task a INNER JOIN risk_activity b ON a.activity_id  = b.oid " +
                " INNER JOIN risk_activity_cooper c ON b.oid =c.activity_id WHERE  a.taskStatus =  " + key + "  AND c.org_id =" + comId;
        return querySqlCounts(sql);
    }
}
