package com.bcxin.risk.surveytk;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.base.dao.QueryHelper;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.survey.domain.ProductCode;
import com.bcxin.risk.survey.domain.SurveyTask;
import com.bcxin.risk.surveytk.domain.dto.SurveyTaskDataDto;
import com.bcxin.risk.surveytk.domain.dto.SurveyTaskDto;
import com.bcxin.risk.surveytk.enums.SurveyStatusEnum;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author hzp
 * 踏勘任务DAO实现层
 */
@Repository("surveyTkTaskDao")
@SuppressWarnings("unchecked")
public class SurveyTkTaskDaoImpl extends DaoImpl<SurveyTask> implements SurveyTkTaskDao{

    @Override
    public SurveyTask findSurveyTaskByOid(Long oid) {
        return selectById(oid);
    }

    @Override
    public List<SurveyTaskDataDto> findSurveyTaskList(SurveyTaskDto searchDto, Page page) {
        List<Map<String, Object>> list = Lists.newArrayList();
        SelectWrapper wrapper = SelectWrapper.instance();
        StringBuffer sql = new StringBuffer();
        sql.append("select DISTINCT A.oid,A.activity_id as activityId,");
        sql.append("ACT.`name` AS activityName,");
        sql.append("B.orderStatus, G.reportUrgent,");
        sql.append("F.`name` as activityVenue,");
//        sql.append("E.realName AS realName,");
        sql.append("case A.taskStatus when '103' then " +
                "(select N.realName from risk_surveytask M,risk_se_user N where M.userId=N.oid and M.surveyTaskStatus='REFUSE' and M.taskId=A.oid order by A.oid desc limit 1) " +
                "else E.realName end as realName, ");
        sql.append("(select IFNULL(N.realName,'--') from risk_se_user N where N.oid=A.consultation_id limit 1) as consultationName, ");
        sql.append("E.userName AS tkUserName,");
        sql.append("E.oid AS tkUserId,");
        sql.append("A.acceptStatus,");
        sql.append("A.taskStatus,");
        sql.append("IF(INSTR(A.zj_config,'"+ ProductCode.EXPERT_TYPE_3 +"'),'1','0') AS zjConfig,");
        sql.append("IF(A.tk_config='"+ ProductCode.SURVEY_LEVEL_1 +"' OR A.tk_config='"+ ProductCode.SURVEY_LEVEL_2 +"' OR A.tk_config ='"+ ProductCode.SURVEY_LEVEL_3 +"',\"1\",\"0\") AS tkConfig,");
        sql.append("DATE_FORMAT(A.acceptDate,'%Y-%m-%d %H:%i:00') AS 'acceptDate',");
        sql.append("DATE_FORMAT(A.finishDate,'%Y-%m-%d %H:%i:00') AS 'finishDate',");
        sql.append("DATE_FORMAT(A.createOn,'%Y-%m-%d %H:%i:00') AS 'createOn' ");
        sql.append("FROM risk_task A ");
        sql.append("INNER JOIN RISK_ACTIVITY ACT ON ACT.oid=A.activity_id ");
        sql.append("INNER JOIN RISK_OrderForm B ON A.activity_id = B.activity_id ");
        sql.append("INNER JOIN risk_activity_cooper C ON A.activity_id = C.activity_id ");
        sql.append("INNER JOIN risk_se_user D ON D.org_id = C.org_id ");
        sql.append("inner join risk_report G on G.activity_id=A.activity_id ");
        sql.append("LEFT JOIN risk_se_user E ON E.oid = A.assgin_id ");
        sql.append("LEFT JOIN (select V.activity_id,group_concat(SV.`name`) as `name` from risk_activity_venue V,sys_venue SV where V.venue_id=SV.oid group by V.activity_id) F on F.activity_id=A.activity_id ");
        sql.append("WHERE A.taskType = '2' and B.orderStatus != "+ DictConst.ORDERSTATUS_YSC+" ");

        // 只筛选出已经支付的订单 (PSS3.4版本要求，add 2018-10-22)
        sql.append(" and B.orderStatus in ("+DictConst.ORDERSTATUS_YZF+","+DictConst.ORDERSTATUS_YHZF+") ");

        if(searchDto.getUserId() != null) {
            sql.append(" and D.oid = "+searchDto.getUserId()).append("\r\n");
        }
        if(StringUtil.isNotEmpty(searchDto.getReportUrgent())){
            sql.append(" and G.reportUrgent = "+searchDto.getReportUrgent()).append("\r\n");
        }
        if(StringUtil.isNotEmpty(searchDto.getAcceptStatus())){
            sql.append(" and  A.acceptStatus= "+searchDto.getAcceptStatus()).append("\r\n");
        }
        if(StringUtil.isNotEmpty(searchDto.getTaskStatus())){
            sql.append(" and  A.taskStatus= "+searchDto.getTaskStatus()).append("\r\n");
        }
        if(StringUtil.isNotEmpty(searchDto.getProvince())){
            sql.append(" and  ACT.province_id= "+searchDto.getProvince()).append("\r\n");
        }
        if(StringUtil.isNotEmpty(searchDto.getCity())){
            sql.append(" and  ACT.city_id= "+searchDto.getCity()).append("\r\n");
        }
        if(StringUtil.isNotEmpty(searchDto.getKeyName())){
            sql.append(" and  A.`name` like '%"+searchDto.getKeyName()+"%'").append("\r\n");

        }
        wrapper.orderBy("A.createOn", false);

        if ( page == null ){
            list = queryMaps(sql.toString(), wrapper);
        }else{
            Page<Map<String, Object>> pageList = queryMapsPage(sql.toString(), wrapper, page);
            list = pageList.getRecords();
        }

        List<SurveyTaskDataDto> dtoList = new ArrayList<>();
        list.forEach(result ->{
            SurveyTaskDataDto dto = new SurveyTaskDataDto(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }

    /**
     * 根据任务id+踏勘状态获取对应的踏勘任务
     * @param taskId 任务id
     * @param surveyStatusEnum 探勘状态
     * @return
     */
    @Override
    public SurveyTask findSurveyTaskByTaskId(Long taskId,SurveyStatusEnum surveyStatusEnum){
        List<Criterion> criterionList = new ArrayList<Criterion>();
        criterionList.add(Restrictions.eq("task.oid", taskId));

        if(surveyStatusEnum!=null){
            List<String> surveyTaskStatus = new ArrayList<String>();
            surveyTaskStatus.add(surveyStatusEnum.getKey());
            criterionList.add(Restrictions.in("surveyTaskStatus",surveyTaskStatus));
        }
        Order[] orders=new Order[]{Order.desc("oid")};
        List<SurveyTask> list= this.selectList(criterionList,orders);
        if(list==null || list.size()==0){
            return null;
        }
        return list.get(0);
    }


    /**
     * 获取踏勘计划列表
     * @param surveyTaskId
     * @return
     */
    @Override
    public List<Map<String, Object>> findSurveyPlan(Long surveyTaskId,String step,Long venueId){
        List<Map<String, Object>> list=new ArrayList<>();
        String sql = "select \n" +
                "A.oid as feedBackId,-- 踏勘反馈id \n" +
                "B.oid as planId,-- 踏勘计划id\n" +
                "C.oid as surveyTaskId,-- 踏勘任务id\n" +
                "E.oid as venueId, -- 场馆id\n" +
                "D.oid as questionnaireId,-- 踏勘问卷id\n" +
                "B.surveyStep, -- 踏勘阶段\n" +
                "B.taskStatus as planStatus,-- 计划状态\n" +
                "D.reportPath as surveyReport, -- 踏勘报告\n" +
                "F.tkExpert,-- 踏勘专家 \n"+
                "case when B.allDay=1 then DATE_FORMAT(B.beginTime,'%Y-%m-%d')\n" +
                "else DATE_FORMAT(B.beginTime,'%Y-%m-%d %H:%i') end as beginTime,-- 踏勘开始时间\n" +
                "case when B.allDay=1 then DATE_FORMAT(B.endTime,'%Y-%m-%d')\n" +
                "else DATE_FORMAT(B.endTime,'%Y-%m-%d %H:%i') end as endTime, -- 踏勘结束时间\n" +
                "E.`name` as venueName -- 踏勘场馆\n" +
                "from risk_survey_feedback A\n" +
                "inner join risk_surveyplan B on A.oid=B.feedBackId\n" +
                "inner join risk_surveytask C on A.taskId=C.oid\n" +
                "inner join risk_Survey_Questionnaire D on A.oid=D.feedBackId and D.venueId=B.venueId\n" +
                "inner join sys_venue E on E.oid=B.venueId\n" +
                "left join (" +
                "select M.surveyStep,M.surveyTaskId,CONCAT(N.realName,' ',N.phone) as tkExpert \n" +
                "from risk_survey_expert M,risk_se_user N where M.expertUserId=N.oid\n" +
                ") F on (F.surveyStep=B.surveyStep and C.oid=F.surveyTaskId)\n"+
                "where C.oid="+surveyTaskId+" and B.surveyStep='"+step+"'";

        if(venueId!=null){
            sql+=" and E.oid="+venueId;
        }
        sql+=" order by B.oid asc";
        list = queryMaps(sql.toString());
        return list;
    }


    /**
     * 获取踏勘整改意见
     * @param questionIds 踏勘问卷id集合
     * @return
     */
    @Override
    public List<Map<String, Object>> findSurveySuggest(List<Long> questionIds){
        // 在当前事务执行group_concat长度设置
        String sqlGroup="SET SESSION group_concat_max_len=5120";
        QueryHelper.executeSql(sqlGroup,null);
        // 整改意见
        String sql="select DISTINCT " +
                "C.taskId surveyTaskId,A.questionnaireId,C.surveyStep," +
                "A.answer as tkResult," +
                "B.result as reformResult," +
                "A.reformId," +
                "D.photos as tkPhotos," +
                "E.photos as reformPhoto "+
                "from risk_survey_info A " +
                "inner join risk_surveyreform B on A.reformId=B.oid " +
                "inner join risk_surveyplan C on C.questionnaireId=A.questionnaireId " +
                "inner join risk_surveyproject F on F.oid=A.oid "+
                "left join (select surveyInfoId as surveyInfoId,GROUP_CONCAT(path) as photos from risk_survey_photo " +
                "group by surveyInfoId) D on D.surveyInfoId=A.oid " +
                "left join(select correctionId as correctionId,GROUP_CONCAT(path) as photos from risk_survey_photo " +
                "group by correctionId) E on A.reformId=E.correctionId "+
                "where A.nextSurvey=1 ";

        String ids="";
        for(Long id : questionIds){
            ids+=id+",";
        }
        if(StringUtil.isNotEmpty(ids)){
            ids=ids.substring(0,ids.length()-1);
        }
        sql+="and A.questionnaireId in ("+ids+")";
        sql+=" order by F.sort asc";
        List<Map<String,Object>> list = queryMaps(sql.toString());
        return list;
    }

    /**
     * 获取场馆
     * @param surveyTaskId
     * @param step
     * @return
     */
    @Override
    public Long getVenue(Long surveyTaskId,String step){
        String sql="select distinct C.venueId from risk_surveytask A,risk_survey_feedback B,risk_surveyplan C " +
                "WHERE A.oid=B.taskId and C.feedBackId=B.oid and  A.oid="+surveyTaskId+" and B.surveyStep='"+step+"'";
        List<Map<String,Object>> list = queryMaps(sql.toString());
        if(list!=null && list.size()>0){
            return Long.parseLong(list.get(0).get("venueId").toString());
        }
        return null;
    }

    @Override
    public boolean checkSurveyExpertAndDoing(Activity activity, String step){
        String sql="select" +
                " A.oid," +
                " case A.surveyStep when 'FIRST' then 1 " +
                " when 'SECOND' then 2 when 'THIRD' then 3 else '' end surveyStep, " +
                " A.taskStatus," +
                " E.tkExpert," +
                " act.oid as activityId" +
                " from RISK_SurveyPlan A" +
                " inner join risk_surveytask B on A.taskId=B.oid" +
                " inner join risk_activity act on act.oid=B.activityId" +
                " left join(" +
                " select M.surveyStep,M.taskId,N.oid as tkExpert" +
                " from risk_survey_expert M,risk_se_user N where M.expertUserId=N.oid" +
                " ) E on (E.taskId=B.taskId and A.surveyStep=E.surveyStep)" +
                " where act.oid="+activity.getOid()+" and A.taskStatus IN ('CONTINUE','COMPLETE') and A.surveyStep='"+step+"' order by B.oid,A.time asc" ;

        List<Map<String,Object>> list = queryMaps(sql.toString());
        if(list!=null && list.size()>0){
            return false;
        }
        return true;

    }
}
