package com.bcxin.risk.survey;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.survey.domain.Survey_Rectification;
import com.bcxin.risk.survey.domain.Survey_Rectification_Info;
import com.bcxin.risk.survey.domain.dto.data.SurveyInfoDTO;
import com.bcxin.risk.survey.domain.dto.serach.Survey_Rectification_InfoSerachDto;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;


@Repository("survey_Rectification_InfoDao")
@SuppressWarnings("unchecked")
public class Survey_Rectification_InfoDaoImpl extends DaoImpl<Survey_Rectification_Info> implements Survey_Rectification_InfoDao {

    @Override
    public List<Survey_Rectification_Info> findInfoByRectification(Survey_Rectification rectification) {
//        Order order= Order.desc("oid");
        return selectList(Restrictions.eq("survey_Rectification", rectification));
    }

    @Override
    public List<SurveyInfoDTO> findInfoByReport(Long reportId) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select info.opinion,info.opinionAttachmentUrl,info.solve,info.solveAttachmentUrl " +
                " from risk_survey_rectification r " +
                " inner join risk_survey_rectification_info info on info.survey_RectificationId = r.oid " +
                " inner join risk_report re on re.activity_id = r.activity_id ";
        if ( reportId == null) {
            return Lists.newArrayList();
        }
        wrapper.eq("re.oid", reportId);
        List<SurveyInfoDTO> dtoList = Lists.newArrayList();
        List<Map<String, Object>> list = queryMaps(sql,wrapper);
        list.forEach(result -> {
            SurveyInfoDTO dto = new SurveyInfoDTO(result);
            dtoList.add(dto);
        });
        return dtoList;
    }

    @Override
    public List<SurveyInfoDTO> findSelfInfoByActivity(Long activityId) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = " SELECT " +
                "  sv.name as venueName," +
                "  rsi.answer AS opinion, " +
                "  rsp1.path AS opinionAttachmentUrl, " +
                "  rsr.result AS solve, " +
                "  rsp2.path AS solveAttachmentUrl " +
                " FROM risk_surveytask rs " +
                " INNER JOIN risk_survey_feedback rsf ON rs.oid = rsf.taskId " +
                " INNER JOIN risk_survey_questionnaire rsq ON rsq.feedBackId = rsf.oid " +
                " INNER JOIN sys_venue sv ON rsq.venueId = sv.oid " +
                " INNER JOIN risk_survey_info rsi ON rsq.oid = rsi.questionnaireId " +
                " LEFT JOIN risk_survey_photo rsp1 ON rsi.oid = rsp1.surveyInfoId " +
                " LEFT JOIN risk_surveyreform rsr ON rsi.reformId = rsr.oid " +
                " LEFT JOIN risk_survey_photo rsp2 ON rsr.oid = rsp2.correctionId" +
                " WHERE " +
                " rs.activityId = "+activityId+" " ;
        if ( activityId == null) {
            return Lists.newArrayList();
        }
        List<SurveyInfoDTO> dtoList = Lists.newArrayList();
        List<Map<String, Object>> list = queryMaps(sql,wrapper);
        list.forEach(result -> {
            SurveyInfoDTO dto = new SurveyInfoDTO(result);
            dtoList.add(dto);
        });
        return dtoList;
    }

    @Override
    public Survey_Rectification_Info findSurveyRectificationInfoByOid(long oid) {
        return selectById(oid);
    }

    public Survey_Rectification_Info findSurvey_Rectification_InfoByOid(Long oid){
        return selectById(oid);
    }

    @Override
    public List<Survey_Rectification_Info> findSurvey_Rectification_InfoList(Survey_Rectification_InfoSerachDto searchDto, Page page) {
        List<Criterion> criterionList = Lists.newArrayList();
        if (StringUtil.isNotEmpty(searchDto.getOpinion()) ) {
            criterionList.add(Restrictions.eq("opinion", searchDto.getOpinion()));
        }
        if ( page == null ) {
            return selectList(criterionList);
        }
        return selectPage(criterionList,page);
    }


}
