package com.bcxin.risk.survey;

import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.dao.DBConnection;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.report.enums.QuestionType;
import com.bcxin.risk.report.enums.SurveyStep;
import com.bcxin.risk.survey.domain.SurveyReform;
import com.bcxin.risk.survey.domain.Survey_Info;
import com.bcxin.risk.survey.domain.dto.serach.Survey_infoSerachDto;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


@Repository("survey_InfokDao")
@SuppressWarnings("unchecked")
public class Survey_InfoDaoImpl extends DaoImpl<Survey_Info> implements Survey_InfoDao {

    public Survey_Info findSurvey_InfoByOid(Long oid){
         return selectById(oid);
    }

    @Override
    public List<Survey_Info> findSurvey_InfoList(Survey_infoSerachDto searchDto, Page page) {
        List<Criterion> criterionList = Lists.newArrayList();
        if ( searchDto.getQuestionnaire() != null ) {
            criterionList.add(Restrictions.eq("questionnaire", searchDto.getQuestionnaire()));
        }
        if ( page == null ) {
            return selectList(criterionList);
        }
        return selectPage(criterionList,page);
    }

    @Override
    public Survey_Info findSurveyInfoByReform(SurveyReform reform) {
        List<Criterion> criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq("surveyReform", reform));
        List list = selectList(criterionList);
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        return (Survey_Info)list.get(0);
    }





    @Override
    public List<Survey_Info> findSurveyInfoByTags(String tags) {
        StringBuffer sql = new StringBuffer("select addon.* from dede_archives archives join dede_addon32 addon on archives.id = addon.aid ");
        sql.append(" and archives.arcrank !='-2' and addon.wentitimu !='' ");
        sql.append(" and addon.shifouguding='否' ");
        if(StringUtil.isNotEmpty(tags)){
            for(String tag:tags.split(",")){
                String label="";
                for(int i = 1; i<= 6; i++){
                    if(i==1)
                        label =" addon.biaoqian"+i+" ="+tag+"";
                    else
                        label = label + " or addon.biaoqian"+i+" ="+tag+"";
                }
                if(StringUtil.isNotEmpty(label))
                    sql.append(" and ("+ label +") ");
            }
        }
		/*if(StringUtil.isNotEmpty(tags)){
			tags = "("+tags+")";
			String label="";
        	for(int i = 1; i<= 6; i++){
        		if(i==1)
        			label =" addon.biaoqian"+i+" in"+tags;
        		else
        			label = label + " or addon.biaoqian"+i+" in"+tags;
        	}
        	if(StringUtil.isNotEmpty(label))
        		sql.append(" and ("+ label +") ");
		}*/
        System.out.println(sql);
        List<Survey_Info> surveyInfos = new ArrayList<Survey_Info>();
        try {
            Statement st = DBConnection.getDraftConnection().createStatement();
            ResultSet rs = st.executeQuery(sql.toString());
            while(rs.next()){
                Survey_Info surveyInfo = new Survey_Info();
                surveyInfo.setAid(rs.getString("aid"));
                surveyInfo.setAnswerTip(rs.getString("takanjieguotishi"));
                surveyInfo.setCreateOn(new Date());

                surveyInfo.setQuestion(rs.getString("wentitimu"));
                surveyInfo.setSurveyStep(SurveyStep.convertName(rs.getString("takancishu")));
                String shifouguding= rs.getString("shifouguding");
                if(shifouguding.equals("是"))
                    surveyInfo.setQuestionType(QuestionType.FIXED);
                else
                    surveyInfo.setQuestionType(QuestionType.UNFIXED);

                surveyInfos.add(surveyInfo);
            }
            rs.close();
            st.close();
        } catch (Exception e) {
            System.out.println(e);
        }
        return surveyInfos;
    }

    @Override
    public Survey_Info findSurveyInfoByAid(String aid) {
        StringBuffer sql = new StringBuffer("select addon.* from dede_archives archives join dede_addon32 addon on archives.id = addon.aid ");
        sql.append(" and archives.arcrank !='-2' ");
        if(StringUtil.isNotEmpty(aid)){
            sql.append(" and addon.aid='"+ aid +"' ");
        }
        System.out.println(sql.toString());
        Survey_Info surveyInfo = new Survey_Info();
        try {
            Statement st = DBConnection.getDraftConnection().createStatement();
            ResultSet rs = st.executeQuery(sql.toString());
            while(rs.next()){
                surveyInfo.setAid(rs.getString("aid"));
                surveyInfo.setAnswerTip(rs.getString("takanjieguotishi"));
                surveyInfo.setCreateOn(new Date());
                surveyInfo.setQuestion(rs.getString("wentitimu"));
                surveyInfo.setSurveyStep(SurveyStep.convertName(rs.getString("takancishu")));
                String shifouguding= rs.getString("shifouguding");
                if(shifouguding.equals("是"))
                    surveyInfo.setQuestionType(QuestionType.FIXED);
                else
                    surveyInfo.setQuestionType(QuestionType.UNFIXED);

            }
            rs.close();
            st.close();
        } catch (Exception e) {
            System.out.println(e);
        }
        return surveyInfo;
    }
}
