package com.bcxin.risk.survey;

import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.report.enums.SurveyStep;
import com.bcxin.risk.survey.domain.SurveyTask;
import com.bcxin.risk.survey.domain.Survey_FeedBack;
import com.bcxin.risk.survey.domain.dto.serach.Survey_FeedBackSerachDto;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;

/**
 * @param
 * @return
 * @auther Administrator
 * @date 2017/04/24 0024
 * @注意事项 </b>
 */

@Repository("survey_FeedBackDao")
@SuppressWarnings("unchecked")
public class Survey_FeedBackDaoImpl extends DaoImpl<Survey_FeedBack> implements Survey_FeedBackDao {

    @Override
    public Survey_FeedBack findSurvey_FeedBackByOid(Long oid){
        return selectById(oid);
    }

    @Override
    public List<Survey_FeedBack> findSurvey_FeedBackList(Survey_FeedBackSerachDto searchDto, Page page) {
        List<Criterion> criterionList = Lists.newArrayList();
        if ( searchDto.getSurveyStep()!= null ) {
            criterionList.add(Restrictions.eq("sueveyStep", searchDto.getSurveyStep()));
        }
        if ( searchDto.getSurveyTask()!= null ) {
            criterionList.add(Restrictions.eq("sueveyTask", searchDto.getSurveyTask()));
        }
        if ( searchDto.getUser()!= null ) {
            criterionList.add(Restrictions.eq("user", searchDto.getUser()));
        }
        if ( page == null ) {
            return selectList(criterionList);
        }
        return selectPage(criterionList,page);
    }

    /**
     * 获取踏勘反馈信息
     * @param task 踏勘任务
     * @param surveyStep 任务阶段
     * @return
     */
    @Override
    public Survey_FeedBack findSurveyFeedBackByTaskAndStep(SurveyTask task, SurveyStep surveyStep){
        List<Criterion> criterionList = new ArrayList<Criterion>();
        criterionList.add(Restrictions.eq("surveyTask.oid", task.getOid()));
        criterionList.add(Restrictions.eq("surveyStep", surveyStep));
        List<Survey_FeedBack> list = this.selectList(criterionList);
        if(list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    /**
     * 根据任务id获取踏勘反馈列表
     * @param taskId
     * @return
     */
    @Override
    public List<Survey_FeedBack> findSurveyFeedBackListBySurveyTaskId(Long taskId){
        List<Criterion> criterionList = new ArrayList<Criterion>();
        criterionList.add(Restrictions.eq("surveyTask.oid", taskId));
        return this.selectList(criterionList,Order.asc("surveyStep"));
    }



}
