package com.bcxin.risk.survey;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.survey.domain.SurveyProject;
import com.bcxin.risk.survey.domain.dto.serach.SurveyProjectSerachDto;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository("surveyProjectDao")
@SuppressWarnings("unchecked")
public class SurveyProjectDaoImpl extends DaoImpl<SurveyProject> implements SurveyProjectDao {
    public SurveyProject findSurveyProjectByOid(Long oid){
        return selectById(oid);
    }

    @Override
    public List<SurveyProject> findSurveyProjectList(SurveyProjectSerachDto searchDto, Page page) {
        List<Criterion> criterionList = Lists.newArrayList();
        if ( searchDto.getSurveyStep()!= null ) {
            criterionList.add(Restrictions.eq("surveyStep", searchDto.getSurveyStep()));
        }
        if (StringUtil.isNotEmpty(searchDto.getQuestion()) ) {
            criterionList.add(Restrictions.eq("question", searchDto.getQuestion()));
        }
        if ( page == null ) {
            return selectList(criterionList);
        }
        return selectPage(criterionList,page);
    }

}
