package com.bcxin.risk.survey;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.survey.domain.SurveyExpert;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author hzp
 * 踏勘专家DAO实现层
 */
@Repository("surveyExpertDao")
@SuppressWarnings("unchecked")
public class SurveyExpertDaoImpl  extends DaoImpl<SurveyExpert> implements SurveyExpertDao {

    @Override
    public String findSurveyExperts(Long taskId){
        String sql="select distinct B.oid,B.realName,B.phone from risk_survey_expert A,risk_se_user B where A.expertUserId=B.oid " +
                "and A.taskId="+taskId;
        SelectWrapper wrapper = SelectWrapper.instance();
        List<Map<String, Object>> list =  queryMaps(sql,  wrapper);
        String expert="";
        if(list!=null && list.size()>0){
            for(Map<String,Object> map : list){
                expert+=getMapValue(map,"realName")+" "+getMapValue(map,"phone")+",";
            }
            if(StringUtil.isNotEmpty(expert)){
                expert=expert.substring(0,expert.length()-1);
                return expert;
            }else{
                return "--";
            }
        }else{
            return "--";
        }
    }

    public String getMapValue(Map<String,Object> map,String key){
        if(map.containsKey(key)){
            if(map.get(key)!=null){
                return map.get(key).toString();
            }
        }
        return "";
    }
}
