package com.bcxin.risk.survey;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.report.enums.AssignType;
import com.bcxin.risk.survey.domain.SurveyAssist;
import com.bcxin.risk.survey.domain.dto.serach.SurveyAssistSerachDto;
import com.bcxin.risk.surveytk.enums.ApprovalStatusEnum;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;


@Repository("surveyAssistDao")
@SuppressWarnings("unchecked")
public class SurveyAssistDaoImpl extends DaoImpl<SurveyAssist> implements SurveyAssistDao {
    @Override
     public SurveyAssist findSurveyAssistByOid(Long oid){
        return selectById(oid);
    }

    @Override
    public List<SurveyAssist> findSurveyAssistList(SurveyAssistSerachDto searchDto, Page page) {
        List<Criterion> criterionList = Lists.newArrayList();
        if ( searchDto.getSurveyStep() != null ) {
            criterionList.add(Restrictions.eq("surveyStep", searchDto.getSurveyStep()));
        }
        if ( searchDto.getAccepter() != null ) {
            criterionList.add(Restrictions.eq("accepter", searchDto.getAccepter()));
        }
        if ( searchDto.getAssignType() != null ) {
            criterionList.add(Restrictions.eq("assignType", searchDto.getAssignType()));
        }
        if ( searchDto.getSurveyTask() != null ) {
            criterionList.add(Restrictions.eq("sueveyTask", searchDto.getSurveyTask()));
        }
        if ( page == null ) {
            return selectList(criterionList);
        }
        return selectPage(criterionList,page);
    }

    /**
     * 根据踏勘任务id获取已经审批通过的专家
     * @param surveyTaskId
     * @return
     */
    @Override
    public List<Long> findTKExperts(Long surveyTaskId){
        List<Long> expertList=new ArrayList<>();
        String type=AssignType.APPLYEXPERT.toString();
        String status=ApprovalStatusEnum.PASS.getKey();
        String sql="select DISTINCT experts from RISK_SurveyAssist "+
                " where taskId="+surveyTaskId+" and assignType='"+type+"' and assignStatus='"+status+"'";

        List<Map<String, Object>> list=queryMaps(sql);
        if(list.isEmpty()){
            return null;
        }else{
            for(Map<String,Object> map : list){
                String experts=map.get("experts").toString();
                if(StringUtil.isNotEmpty(experts)){
                    // 去重
                    String [] sList=experts.split("#");
                    for(String tmp : sList){
                        if(!expertList.contains(tmp)){
                            expertList.add(Long.parseLong(tmp));
                        }
                    }
                }
            }
            return expertList;
        }
    }
}
