package com.bcxin.risk.report.material;

import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.report.material.dao.MaterialFormOrgDao;
import com.bcxin.risk.report.material.domain.MaterialFormOrg;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public class MaterialFormOrgDaoImpl extends DaoImpl<MaterialFormOrg> implements MaterialFormOrgDao {

	@Override
	public List<MaterialFormOrg> findByOrgType(String orgType) {
		List<Criterion> criterionList = Lists.newArrayList();

		criterionList.add(Restrictions.eq("orgType",orgType));
		Order order=Order.desc("seq");
		List list  =  selectList(criterionList,order);
		if(list.size()>0){
			return list ;
		}
		return null ;
	}
}
