package com.bcxin.risk.report.material;

import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.report.material.dao.MaterialFormOptionDao;
import com.bcxin.risk.report.material.domain.MaterialFormOption;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

@Repository
@Slf4j
public class MaterialFormOptionDaoImpl extends DaoImpl<MaterialFormOption> implements MaterialFormOptionDao {

	@Override
	public List<MaterialFormOption> selectOptionList() {
		return selectList();
	}

	@Override
	public List<MaterialFormOption> selectDIYOptionList(String tableName,String columnName,String filedWhere,String filedWhereValue) {
		String sql = "select oid," + columnName
				+ " from " + tableName + " ";
		SelectWrapper wrapper = SelectWrapper.instance();
		wrapper.eq(filedWhere,filedWhereValue);
		List<Map<String, Object>> list = queryMaps(sql, wrapper);

		List<MaterialFormOption> dtoList = Lists.newArrayList();
		list.forEach(result -> {
			MaterialFormOption dto = new MaterialFormOption();
			dto.setName(result.get(columnName).toString());
			dto.setValue(result.get("oid").toString());
			dtoList.add(dto);
		});
		return dtoList;
	}

}
