package com.bcxin.risk.policy;

import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.policy.domain.RateSpec;
import com.bcxin.risk.policy.dto.search.RateSpecSerachDto;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;


@Repository("rateSpecDao")
@SuppressWarnings("unchecked")

public class RateSpecDaoImpl extends DaoImpl<RateSpec> implements RateSpecDao {
    public RateSpec findRateSpecByOid(Long oid){
        return selectById(oid);
    }

    @Override
    public List<RateSpec> findRateSpecList(RateSpecSerachDto searchDto, Page page) {
        List<Criterion> criterionList = Lists.newArrayList();
        if ( searchDto.getPlan() != null ) {
            criterionList.add(Restrictions.eq("plan", searchDto.getPlan()));
        }
        if ( page == null ) {
            return selectList(criterionList);
        }
        return selectPage(criterionList,page);
    }
}
