package com.bcxin.risk.policy;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.policy.domain.InsurancePolicy;
import com.bcxin.risk.policy.domain.PolicyExtra;
import com.bcxin.risk.policy.dto.search.PolicyExtraSerachDto;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @return
 * @auther Administrator
 * @date 2017/04/24 0024
 * @注意事项 </b>
 */

@Repository("policyExtraDao")
@SuppressWarnings("unchecked")

public class PolicyExtraDaoImpl extends DaoImpl<PolicyExtra> implements PolicyExtraDao {
    
    public PolicyExtra findPolicyExtraByOid(Long oid){
        return selectById(oid);
    }

    @Override
    public List<PolicyExtra> findPolicyExtraList(PolicyExtraSerachDto searchDto, Page page) {
        List<Criterion> criterionList = Lists.newArrayList();
        if ( searchDto.getActivity()!= null ) {
            criterionList.add(Restrictions.eq("activity", searchDto.getActivity()));
        }
        if ( searchDto.getPolicy()!= null ) {
            criterionList.add(Restrictions.eq("policy", searchDto.getPolicy()));
        }
        if (StringUtil.isNotEmpty(searchDto.getReportName()) ) {
            criterionList.add(Restrictions.eq("reportName", searchDto.getReportName()));
        }
        if ( page == null ) {
            return selectList(criterionList);
        }
        return selectPage(criterionList,page);
    }
    @Override
    public PolicyExtra findPolicyExtraByPolicy(InsurancePolicy policy) {
        List<Criterion> criterionList = Lists.newArrayList();
        if (policy != null) {
            criterionList.add(Restrictions.eq("policy", policy));
        }

        List<PolicyExtra> plist = selectList(criterionList);
        if (plist.size() > 0) {
            return plist.get(0);
        }
        return null;
    }
}
