package com.bcxin.risk.policy;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.policy.domain.MailPolicy;
import com.bcxin.risk.policy.dto.search.MailPolicySerachDto;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;


@Repository("mailPolicyDao")
@SuppressWarnings("unchecked")

public class MailPolicyDaoImpl extends DaoImpl<MailPolicy> implements MailPolicyDao {
    public MailPolicy findMailPolicyByOid(Long oid){
        return selectById(oid);
    }

    @Override
    public List<MailPolicy> findMailPolicyList(MailPolicySerachDto searchDto, Page page) {
        List<Criterion> criterionList = Lists.newArrayList();
        if ( searchDto.getPolicy() != null ) {
            criterionList.add(Restrictions.eq("policy", searchDto.getPolicy()));
        }
        if (StringUtil.isNotEmpty(searchDto.getInvoiceTitle()) ) {
            criterionList.add(Restrictions.eq("invoiceTitle", searchDto.getInvoiceTitle()));
        }
        if ( page == null ) {
            return selectList(criterionList);
        }
        return selectPage(criterionList,page);
    }


}
