package com.bcxin.risk.policy;

import com.bcxin.risk.hibernateplus.condition.CriterionWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.policy.domain.DutySpec;
import com.bcxin.risk.policy.domain.InsuranceProduct;
import com.bcxin.risk.policy.domain.ProductIntroduce;
import com.bcxin.risk.policy.dto.search.InsuranceProductSerachDto;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository("insuranceProductDao")
@SuppressWarnings("unchecked")
public class InsuranceProductDaoImpl extends DaoImpl<InsuranceProduct> implements InsuranceProductDao {

	@SuppressWarnings("unchecked")
	public List<InsuranceProduct> insuranceProductList() {
		Order order = Order.desc("oid");
		return selectList(order);
	}

	@SuppressWarnings("unchecked")
	public List<InsuranceProduct> effectInsuranceProductList() {
		Order order = Order.asc("oid");
		return selectList(Restrictions.eq("active", Boolean.TRUE),order);
	}

	public InsuranceProduct findInsuranceProductByOid(Long oid){
		return selectById(oid);
	}

	@Override
	public List<InsuranceProduct> findInsuranceProductList(InsuranceProductSerachDto searchDto, Page page) {
		List<Criterion> criterionList = Lists.newArrayList();
		if ( searchDto.getGroupType() != null ) {
			criterionList.add(Restrictions.eq("groupType", searchDto.getGroupType()));
		}
		if ( page == null ) {
			return selectList(criterionList);
		}
		return selectPage(criterionList,page);
	}

	@Override
	public InsuranceProduct findInsuranceProductByExter(String externalReference) {
		return selectOne(CriterionWrapper.instance().eq("externalReference", externalReference));
	}

	@Override
	public ProductIntroduce findProductIntroduceByProduct(InsuranceProduct product) {
		return null;
	}

	@Override
	public List<DutySpec> dutySpecList() {
		return null;
	}

	@Override
	public DutySpec findDutySpecByExter(String external) {
		return null;
	}

}
