package com.bcxin.risk.policy;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.hibernateplus.condition.CriterionWrapper;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.policy.domain.InsurancePolicy;
import com.bcxin.risk.policy.dto.data.PolicyDto;
import com.bcxin.risk.policy.dto.search.PolicySearchDto;
import com.bcxin.risk.policy.enums.PolicyStatus;
import com.bcxin.risk.user.domain.User;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

@Repository("insurancePolicyDao")
@SuppressWarnings("unchecked")
public class InsurancePolicyDaoImpl extends DaoImpl<InsurancePolicy> implements InsurancePolicyDao {

	public InsurancePolicy findInsurancePolicyByOid(Long oid){
		return selectById(oid);
	}

	@Override
	public List<InsurancePolicy> findInsurancePolicyList(PolicySearchDto searchDto, Page page) {
		List<Criterion> criterionList = Lists.newArrayList();
		if ( searchDto.getUser()!= null ) {
			criterionList.add(Restrictions.eq("user", searchDto.getUser()));
		}
		if (StringUtil.isNotEmpty(searchDto.getCname() )) {
			criterionList.add(Restrictions.eq("cname", searchDto.getCname()));
		}

		if ( page == null ) {
			return selectList(criterionList);
		}
		return selectPage(criterionList,page);
	}

	@Override
	public InsurancePolicy findPolicyByActivity(Activity activity) {
		List<Criterion> criterionList = Lists.newArrayList();
		if ( activity == null ) {
			return null;
		}
		criterionList.add(Restrictions.eq("activity", activity));
		List list = selectList(criterionList);
		if(CollectionUtil.isEmpty(list)){
			return null;
		}
		return (InsurancePolicy)list.get(0);
	}
  
	public List<InsurancePolicy> findPolicyByUser(User user) {
		return selectList(CriterionWrapper.instance().eq("user", user));
	}

	/**
	 * 
	 * <b>Function 根据承办方查找活动，并转成dto</b> 
	 * 
	 * @param page
	 * @return
	 * @author LuoPeng
	 * @date 2016年12月21日 下午5:31:13
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public List<PolicyDto> findPolicyList(PolicySearchDto searchDto,DwzPage page){
		SelectWrapper wrapper = SelectWrapper.instance();
		String sql = "select i.oid,i.externalReference,DATE_FORMAT(i.createOn,'%Y-%m-%d %H:%i:%s') AS createOn,pe.reportName,p.`name` as productName,i.policyStatus,i.policyType,i.premium as amount "
					+" ,i.policySerialNumber,i.inceptionDate,i.plannedEndDate,i.htPlannedEndDate,i.signedDate "
					+" ,DATE_FORMAT(i.updateOn,'%Y-%m-%d %H:%i:%s') AS updateOn,i.settlementStatus  from risk_insurancepolicy i"
					+" inner join risk_insuranceproduct p on i.spec_Id = p.oid "
					+" inner join risk_policyextra pe on pe.policy_Id = i.oid "
					+" where 1=1 ";
		if (StringUtil.isNotEmpty(searchDto.getStartDate())){
			sql += "and i.signedDate <= '" +searchDto.getStartDate()+"' ";
		}
		if (StringUtil.isNotEmpty(searchDto.getEndDate())){
			sql += "and i.signedDate >= '" +searchDto.getEndDate()+"' ";
		}

		if(StringUtil.isNotEmpty(searchDto.getOrderSerialNumber())){
			sql += "and i.policySerialNumber like '%"+searchDto.getOrderSerialNumber()+"%' ";
		}
		if(StringUtil.isNotEmpty(searchDto.getExternalReference())){
			sql += "and i.externalReference like '%"+searchDto.getExternalReference()+"%' ";
		}
		if (StringUtil.isNotEmpty(searchDto.getStatus())){
			sql += "and i.policyStatus = '" +searchDto.getStatus()+"' ";
		}

		if(page!= null ){
			page.setTotalCount(querySqlCounts( sql,  wrapper));
			sql = sql + " ORDER BY  i.createOn DESC ,i.oid DESC limit "+(page.getPageNum() - 1) * page.getNumPerPage()+","+page.getNumPerPage()+" ";
		}
		List<PolicyDto> dtoList = Lists.newArrayList();
		List<Map<String, Object>> list = queryMaps(sql, wrapper);
		list.forEach(result -> {
			PolicyDto dto = new PolicyDto(result);
			dtoList.add(dto);
		});
		return dtoList;
	}

	@Override
	public List<PolicyDto> findPolicyByUserPage(PolicySearchDto searchDto,Page page){
		SelectWrapper wrapper = SelectWrapper.instance();
		String sql = "select i.oid,i.externalReference,DATE_FORMAT(i.createOn,'%Y-%m-%d %H:%i:%s') AS createOn,pe.reportName,p.`name` as productName,i.policyStatus,i.policyType,i.premium as amount "
				+" ,i.policySerialNumber,i.inceptionDate,i.plannedEndDate,i.htPlannedEndDate,i.signedDate "
				+" ,DATE_FORMAT(i.updateOn,'%Y-%m-%d %H:%i:%s') AS updateOn,i.settlementStatus  from risk_insurancepolicy i"
				+" inner join risk_insuranceproduct p on i.spec_Id = p.oid "
				+" inner join risk_policyextra pe on pe.policy_Id = i.oid "
				+" where i.user_id = "+searchDto.getUser().getOid()+" ";
		if (StringUtil.isNotEmpty(searchDto.getStartDate())){
			sql += "and i.signedDate <= '" +searchDto.getStartDate()+"' ";
		}
		if (StringUtil.isNotEmpty(searchDto.getEndDate())){
			sql += "and i.signedDate >= '" +searchDto.getEndDate()+"' ";
		}
		if (StringUtil.isNotEmpty(searchDto.getCname())){
			sql += "and ( i.externalReference like '%" +searchDto.getCname()+"%' or pe.reportName like '%" +searchDto.getCname()+"%')";
		}

		if(StringUtil.isNotEmpty(searchDto.getOrderSerialNumber())){
			sql += "and i.policySerialNumber like '%"+searchDto.getOrderSerialNumber()+"%' ";
		}
		if(StringUtil.isNotEmpty(searchDto.getExternalReference())){
			sql += "and i.externalReference like '%"+searchDto.getExternalReference()+"%' ";
		}
		if (StringUtil.isNotEmpty(searchDto.getStatus())){
			sql += "and i.policyStatus = '" +searchDto.getStatus()+"' ";
		}
		wrapper.orderBy(" i.createOn",false);
		wrapper.orderBy(" i.oid",false);

		List<PolicyDto> dtoList = Lists.newArrayList();
		Page<Map<String, Object>> pageList = queryMapsPage(sql, wrapper,page);
		List<Map<String, Object>> list = pageList.getRecords();
		list.forEach(result -> {
			PolicyDto dto = new PolicyDto(result);
			dto.setPage(page);
			dtoList.add(dto);
		});
		return dtoList;
	}


	@Override
	public void updReportPolicyStatus(Activity activity, PolicyStatus status) {
		String sql = "UPDATE  risk_insurancepolicy set  policyStatus = '" + status + "', updateOn = SYSDATE() where  reportId ="
				+ activity.getOid();
		executeSqlUpdate(sql);
	}

}
