package com.bcxin.risk.org;

import com.bcxin.risk.base.dao.BaseDao;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.org.domain.PendOrg;
import com.bcxin.risk.org.domain.PendOrgDao;
import com.bcxin.risk.org.dto.OrgDTO;
import com.bcxin.risk.user.domain.User;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @return
 * @auther Administrator
 * @date 2017/04/24 0024
 * @注意事项 </b>
 */

@Repository("pendOrgDao")
@SuppressWarnings("unchecked")

public class PendOrgDaoImpl extends DaoImpl<PendOrg> implements PendOrgDao {
    @Autowired
    private BaseDao baseDao;


    @Override
     public PendOrg findPendOrgByOid(Long oid){  return selectById(oid);};

    @Override
    public PendOrg findPendOrg(User user, String serviceOrgType){
        List<Criterion> criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq("user",user));
        criterionList.add(Restrictions.eq("serviceOrgType",serviceOrgType));
        List<PendOrg> list=baseDao.findByCriterion(PendOrg.class, criterionList);
        if(list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Override
    public List<PendOrg> findPendOrgList(OrgDTO orgDTO, DwzPage page) {
        Map<String,Object> params = Maps.newHashMap();
        List<Criterion> criterionList = Lists.newArrayList();
        if (orgDTO != null) {
            if (StringUtil.isNotEmpty(orgDTO.getUserName())) {
                criterionList.add(Restrictions.eq("userName", orgDTO.getUserName()));
            }
            if (StringUtil.isNotEmpty(orgDTO.getName())) {
                criterionList.add(Restrictions.like("name","%"+ orgDTO.getName()+"%"));
            }
            if (StringUtil.isNotEmpty(orgDTO.getServiceOrgType())) {
                criterionList.add(Restrictions.eq("serviceOrgType", orgDTO.getServiceOrgType()));
            }
            if (StringUtil.isNotEmpty(orgDTO.getApprovalStatus())) {
                criterionList.add(Restrictions.eq("approvalStatus", orgDTO.getApprovalStatus()));
            }
        }
        List<Order> orderList = new ArrayList<Order>();
        orderList.add(Order.asc("approvalStatus"));
        orderList.add(Order.desc("createOn"));
        if ( page == null ) {
            return baseDao.findByCriterion(PendOrg.class, criterionList,orderList);
        }
        return baseDao.findByCriterionForPage(PendOrg.class, criterionList, page,orderList);
    }

    @Override
    public List newPendOrg() {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT a.`name`,a.userName,DATE_FORMAT( a.createOn ,'%Y-%m-%d %H:%i:%s' ) as createOn,a.serviceOrgType  FROM risk_pendOrg a WHERE 1=1 AND  approvalStatus = '1' ORDER BY createOn DESC LIMIT 5 ";

        return queryMaps(sql, wrapper);
    }

}
