package com.bcxin.risk.org;

import com.bcxin.risk.base.dao.BaseDao;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.org.domain.KnowledgeBase;
import com.bcxin.risk.org.domain.KnowledgeBaseDao;
import org.springframework.stereotype.Repository;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author zhangjianhua
 * @date 2018年9月7日14:53:59
 */
@Repository("KnowledgeBaseDao")
public class KnowledgeBaseDaoImpl extends DaoImpl<KnowledgeBase> implements KnowledgeBaseDao {

    @Resource
    private BaseDao baseDao;


    @Override
    public List ListKnowledgeBaseManage(KnowledgeBase knowledgeBase, DwzPage page) {

        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT * FROM risk_knowledge_base a WHERE 1=1 ";

        if (knowledgeBase != null) {
            if (StringUtil.isNotEmpty(knowledgeBase.getType())) {
                sql += " and a.type =" + knowledgeBase.getType();
            }

            if (StringUtil.isNotEmpty(knowledgeBase.getTitle())) {
                sql += " and a.title like '%" + knowledgeBase.getTitle() + "%'";
            }
        }
        if (page != null) {
            page.setTotalCount(querySqlCounts(sql, wrapper));
            sql = sql + " ORDER BY updateOn DESC limit " + (page.getPageNum() - 1) * page.getNumPerPage() + "," + page.getNumPerPage();
        }
        return queryMaps(sql, wrapper);
    }

    @Override
    public List loadKnowledgeList(String type, DwzPage page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT * FROM risk_knowledge_base a WHERE 1=1";
        if (StringUtil.isNotEmpty(type) && !DictConst.N.equals(type)) {
            sql += " and a.type = '" + type + "'";
        }
        if (page != null) {
            page.setTotalCount(querySqlCounts(sql, wrapper));
            sql = sql + " ORDER BY updateOn DESC limit " + (page.getPageNum() - 1) * page.getNumPerPage() + "," + page.getNumPerPage();
        }
        return queryMaps(sql, wrapper);
    }
}
