package com.bcxin.risk.org;

import com.bcxin.risk.base.dao.BaseDao;
import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.org.domain.GovOrg;
import com.bcxin.risk.org.domain.GovOrgDao;
import com.bcxin.risk.org.dto.OrgDTO;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @return
 * @auther Administrator
 * @date 2017/04/24 0024
 * @注意事项 </b>
 */

@Repository("govOrgDao")
@SuppressWarnings("unchecked")

public class GovOrgDaoImpl extends DaoImpl<GovOrg> implements GovOrgDao {
    @Autowired
    private BaseDao baseDao;


    @Override
     public GovOrg findGovOrgByOid(Long oid){  return selectById(oid);};

    @Override
    public GovOrg findGovOrgByUserName(String userName){
        OrgDTO dto = new OrgDTO();
        dto.setUserName(userName);
        List<GovOrg> orgList = findGovOrgList(dto, null);
        if (CollectionUtil.isNotEmpty(orgList)) {
            return (GovOrg)orgList.get(0);
        }
        return null;
    }

    @Override
    public List<GovOrg> findGovOrgList(OrgDTO orgDTO, DwzPage page) {
        Map<String,Object> params = Maps.newHashMap();
        List<Criterion> criterionList = Lists.newArrayList();
        if (orgDTO != null) {
            if (StringUtil.isNotEmpty(orgDTO.getUserName())) {
                criterionList.add(Restrictions.eq("userName", orgDTO.getUserName()));
            }
            if (StringUtil.isNotEmpty(orgDTO.getName())) {
                criterionList.add(Restrictions.like("name","%"+ orgDTO.getName()+"%"));
            }
            if (StringUtil.isNotEmpty(orgDTO.getApprovalStatus())) {
                criterionList.add(Restrictions.eq("approvalStatus", orgDTO.getApprovalStatus()));
            }
        }
        List<Order> orderList = new ArrayList<Order>();
        orderList.add(Order.asc("approvalStatus"));
        orderList.add(Order.desc("createOn"));
        if ( page == null ) {
            return baseDao.findByCriterion(GovOrg.class, criterionList,orderList);
        }
        return baseDao.findByCriterionForPage(GovOrg.class, criterionList, page,orderList);
    }


    @Override
    public List newGovOrg() {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT a.`name`,a.userName,DATE_FORMAT( a.createOn ,'%Y-%m-%d %H:%i:%s' ) as createOn FROM risk_govOrg a WHERE 1=1 AND  approvalStatus = '1' ORDER BY createOn DESC LIMIT 5 ";

        return queryMaps(sql, wrapper);
    }

    @Override
    public int countGovOrg() {

        String sql = "SELECT oid FROM risk_govorg  WHERE approvalStatus = '2' ";

        return querySqlCounts(sql);
    }
}
