package com.bcxin.risk.org;

import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.org.domain.ExpertOrg;
import com.bcxin.risk.org.domain.ExpertOrgDao;
import com.bcxin.risk.org.dto.ExpertOrgSerachDto;
import com.bcxin.risk.org.dto.OrgDTO;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;


@Repository("expertOrgDao")
@SuppressWarnings("unchecked")
public class ExpertOrgDaoImpl extends DaoImpl<ExpertOrg> implements ExpertOrgDao {

    public List<ExpertOrg> findExpertOrgList(OrgDTO orgDTO, Page page){
        List<Criterion> criterionList = Lists.newArrayList();
        return selectPage(criterionList,page);
    }

    public ExpertOrg findExpertOrgByOid(Long oid){
        return selectById(oid);
    }

    @Override
    public List<ExpertOrg> findExpertOrgList(ExpertOrgSerachDto searchDto, Page page) {
        List<Criterion> criterionList = Lists.newArrayList();
        if ( searchDto.getDescription() != null ) {
            criterionList.add(Restrictions.eq("description", searchDto.getDescription()));
        }
        if ( page == null ) {
            return selectList(criterionList);
        }
        return selectPage(criterionList,page);
    }

}
