package com.bcxin.risk.org;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.dto.data.ValueDTO;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.org.domain.ContractorOrg;
import com.bcxin.risk.org.domain.ContractorOrgDao;
import com.bcxin.risk.org.dto.ContractorOrgSearchDto;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;


@Repository("contractorOrgDao")
public class ContractorOrgDaoImpl extends DaoImpl<ContractorOrg> implements ContractorOrgDao {

    @Override
    public List<ValueDTO> findValidOrgWithOutGov(){
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select d.oid,o.name " +
                " from risk_contractororg d\n" +
                " inner join risk_org o on o.oid = d.oid\n" +
                " left join risk_se_user se on se.org_id = d.oid \n" +
                " where 1=1 \n" +
                " and se.active = 1 " +
                " and se.userType = " + DictConst.USERTYPE_CBDWYH +
                " and se.active is not null " +
                " and channel is not null" ;

        List<ValueDTO> dtoList = Lists.newArrayList();
        List<Map<String, Object>> list  = queryMaps(sql, wrapper);
        list.forEach(result -> {
            ValueDTO dto = new ValueDTO(result);
            dtoList.add(dto);
        });
        return dtoList;
    }


    @Override
    public List<Map<String, Object>> findContractorOrgByDtoForPage(ContractorOrgSearchDto dto, DwzPage page) {
        String sql = "SELECT DISTINCT " +
                "a.oid, " +
                "b.name, " +
                "a.isInstallAuth, " +
                "( " +
                "SELECT " +
                "province " +
                "FROM " +
                "sys_region " +
                "WHERE " +
                "oid = b.province_id " +
                ") AS province, " +
                "( " +
                "SELECT " +
                "city " +
                "FROM " +
                "sys_region " +
                "WHERE " +
                "oid = b.city_id " +
                ") AS city, " +
                "( " +
                "SELECT " +
                "area " +
                "FROM " +
                "sys_region " +
                "WHERE " +
                "oid = b.area_id " +
                ") AS area " +
                "FROM " +
                "risk_contractorOrg a " +
                "INNER JOIN risk_org b ON a.oid = b.oid " +
                "WHERE " +
                "1 = 1 ";
        SelectWrapper wrapper = SelectWrapper.instance();
        if (StringUtil.isNotEmpty(dto.getName())) {
            sql = sql + " AND name like '%" + dto.getName() + "%' ";
        }
        sql = sql + " ORDER BY a.oid DESC ";
        if (page != null) {
            page.setTotalCount(querySqlCounts(sql, wrapper));
            sql = sql + " limit " + (page.getPageNum() - 1) * page.getNumPerPage() + "," + page.getNumPerPage();
        }
        return queryMaps(sql, wrapper);
    }
}
