package com.bcxin.risk.org;

import com.bcxin.risk.base.dao.BaseDao;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.org.domain.Assessment;
import com.bcxin.risk.org.domain.AssessmentDao;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author zhangjianhua
 * @date 2018/4/28
 */
@Repository("AssessmentDao")
public class AssessmentDaoImpl extends DaoImpl<Assessment> implements AssessmentDao {

    @Resource
    private BaseDao baseDao;

    @Override
    public List ListAssessmentListOrg(Long provinceId, DwzPage page) {

        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT * from risk_assessmentorg where 1=1 and provinceId = '610000' ";
        if (provinceId != null) {
            sql = "SELECT * from risk_assessmentorg where 1=1 and provinceId = '" + provinceId + "' ";
        }
        if (page != null) {
            page.setTotalCount(querySqlCounts(sql, wrapper));
            sql = sql + " ORDER BY oid DESC limit " + (page.getPageNum() - 1) * page.getNumPerPage() + "," + page.getNumPerPage();
        }
        return queryMaps(sql, wrapper);
    }

    @Override
    public void saveAssessment(Assessment assessment) {
        saveOrUpdate(assessment);
    }

    @Override
    public Assessment selectAssessment(long oid) {
        return selectById(oid);
    }

    @Override
    public void updateAssessment(Assessment assessment) {
        saveOrUpdate(assessment);
    }

    @Override
    public List findProvinceAssessmentList(String provinceId) {
        List<Criterion> criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq("provinceId", Long.parseLong(provinceId)));
        return baseDao.findByCriterion(Assessment.class, criterionList);
    }

    @Override
    public Assessment findAssessmentByOid(Long oid) {
        return selectById(oid);
    }
}
