package com.bcxin.risk.order;

import cn.hutool.core.date.DatePattern;
import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.base.domain.util.DomainDateUtil;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.constant.TableConst;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.order.dto.data.OrderFormDataDTO;
import com.bcxin.risk.order.dto.search.OrderFormSearchDTO;
import com.bcxin.risk.order.enums.OrderTypeEnum;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author Administrator
 * @return
 * @auther Administrator
 * @date 2017/04/24 0024
 * @注意事项 </b>
 */

@Repository("orderFormDao")
@SuppressWarnings("unchecked")
public class OrderFormDaoImpl extends DaoImpl<OrderForm> implements OrderFormDao {


    @Override
    public OrderForm findOrderFormByOid(Long oid) {
        return selectById(oid);
    }

    @Override
    public OrderForm findOrderFormByNo(String orderNo) {
        return selectOne(SelectWrapper.instance().eq("orderNo", orderNo));
    }


    @Override
    public Map<String, String> countOrderNum(Long userId) {
        SelectWrapper wrapper = SelectWrapper.instance();
        StringBuilder sb = new StringBuilder();
        sb.append("select").append("\r\n");
        sb.append("sum(case A.orderStatus when '" + DictConst.ORDERSTATUS_WZF + "' then 1 else 0 end) as unPayCount,").append("\r\n");
        sb.append("sum(case A.orderStatus when '" + DictConst.ORDERSTATUS_YZF + "' then 1 else 0 end) as payCount").append("\r\n");
        sb.append("from risk_orderform A,risk_activity B").append("\r\n");
        sb.append("where A.orderNo=B.activityNo and B.activityStatus!='" + DictConst.ACTIVITYSTATUS_HDJS + "' and B.user_id=" + userId);

        Map<String, String> countMap = Maps.newHashMap();
        Map<String, Object> result = queryMap(sb.toString().toString(), wrapper);
        countMap.put("unPayCount", result.get("unPayCount") == null ? "0"
                : result.get("unPayCount").toString());
        countMap.put("payCount", result.get("payCount") == null ? "0"
                : result.get("payCount").toString());
        return countMap;

    }

    /**
     * 可操作发票的订单列表
     *
     * @param searchDto
     * @param page
     * @return
     */
    @Override
    public List<OrderFormDataDTO> findFinanceTicketList(OrderFormSearchDTO searchDto, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select e.approvalStatus, e.invoiceType," +
                " e.`comment` as comment," +
                " o.delayPhoto,rep.reportStatus,p.province, " +
                " IFNULL((SELECT city FROM sys_region WHERE oid = a.city_id),'0') as city , " +
                " IFNULL((SELECT area FROM sys_region WHERE oid = a.area_id),'0') as area , " +
                " o.oid as orderId, a.oid as activityId,a.name as activityName, " +
                " a.activitySource, " +
                " a.gov, o.orderNo,DATE_FORMAT(a.orderDate,'%Y-%m-%d %H:%i:%s') AS orderDate,a.activityType,  " +
                " o.orderStatus,a.activityStatus," +
                " o.amount,IFNULL(o.refundAmount,0) as refundAmount,IFNULL(o.sourceAmount,0) as sourceAmount," +
                " off.payOrg,oo.name as orgName," +
                " org.name as pgOrgName,a.isVirtualContractor,a.sponsor,t.paymentMode,t.paymentType, " +
                " DATE_FORMAT(t.endTime,'%Y-%m-%d %H:%i:%s') AS payDate " +
                " from RISK_ACTIVITY a " +
                " inner join sys_region p on p.oid = a.province_id" +
                " inner join RISK_ORDERFORM o on o.activity_id = a.oid " +
                " inner join RISK_SE_USER u on o.user_id = u.oid " +
                " inner join risk_org oo on oo.oid = u.org_id " +
                " INNER JOIN risk_activityexpress e " +
                " ON o.oid = e.orderForm_id" +
                " left join risk_transaction t on t.orderForm_id  = o.oid " +
                " left join risk_transactionoffline off on off.oid = t.oid " +
                " left join risk_report rep on rep.activity_id=a.oid " +
                " left join ( select A.activity_id,A.org_id,C.name from RISK_Activity_Cooper A,risk_serviceorg B,risk_org C " +
                " where B.serviceOrgType=1 and A.org_id=B.oid and A.org_id=C.oid ) org on a.oid=org.activity_id " +
                " WHERE EXISTS (SELECT 1 FROM risk_activity_cooper d ,risk_serviceOrg e " +
                " WHERE d.org_id = e.oid AND e.serviceOrgType = '1' AND d.activity_id = a.oid ) " +
                " and o.orderStatus != 9 and a.isBackup = 0 ";

        if (searchDto.getUser() != null) {
            if (searchDto.getUser().getOrg() != null) {
                //出纳账号显示所有机构数据
                if (!("chuna".equals(searchDto.getUser().getUserName())||("chunali".equals(searchDto.getUser().getUserName())))) {
                    sql = sql + " AND org.org_id  = " + searchDto.getUser().getOrg().getOid();
                }
            }
        }

        if (StringUtil.isNotEmpty(searchDto.getKeyname())) {
            sql = sql + " AND (a.name like '%" + searchDto.getKeyname() + "%' " +
                    " or org.name like '%" + searchDto.getKeyname() + "%' " +
                    " or a.sponsor like '%" + searchDto.getKeyname() + "%' " +
                    " or o.amount like '%" + searchDto.getKeyname() + "%' ) ";
        }
        if (StringUtil.isNotEmpty(searchDto.getOrderStatus())) {
            sql = sql + " AND o.orderStatus = " + searchDto.getOrderStatus() + " ";
        }
        if (StringUtil.isNotEmpty(searchDto.getStartDate())
                && StringUtil.isNotEmpty(searchDto.getEndDate())) {
            sql = sql + " AND a.orderDate between DATE_FORMAT('" + searchDto.getStartDate() + "','%Y-%m-%d %H:%i:%S') " +
                    " and DATE_FORMAT('" + cn.hutool.core.date.DateUtil.format(DomainDateUtil.addDay(DomainDateUtil.parseDate(searchDto.getEndDate()), 1), DatePattern.NORM_DATE_PATTERN) + "','%Y-%m-%d %H:%i:%S')";
        }
        if (StringUtil.isNotEmpty(searchDto.getProvince())) {
            sql = sql + " AND p.oid = " + searchDto.getProvince() + " ";
        }
        if (StringUtil.isNotEmpty(searchDto.getPayMethod())) {
            sql += " and t.paymentMode='" + searchDto.getPayMethod() + "' ";
        }
        if (StringUtil.isNotEmpty(searchDto.getApprovalStatus())) {
            sql += " and e.approvalStatus='" + searchDto.getApprovalStatus() + "' ";
        }
        if (StringUtil.isNotEmpty(searchDto.getPayBeginDate())) {
            sql += " and t.endTime >= '" + searchDto.getPayBeginDate() + "' ";
        }
        if (StringUtil.isNotEmpty(searchDto.getPayEndDate())) {
            sql += " and t.endTime <= '" + searchDto.getPayEndDate() + "' ";
        }

        //过滤演示数据
        if ("testchuna".equals(searchDto.getUser().getUserName())) {
            sql = sql + " and (u.userName = 'chengban' or u.userName = 'chanpinbu')";
        } else {
            sql = sql + " and (u.userName != 'chengban' and userName != 'chanpinbu')";
        }
        wrapper.orderBy("a.oid", false);
        List<OrderFormDataDTO> dtoList = Lists.newArrayList();
        Page<Map<String, Object>> pageList = queryMapsPage(sql, wrapper, page);
        List<Map<String, Object>> list = pageList.getRecords();
        list.forEach(result -> {
            OrderFormDataDTO dto = new OrderFormDataDTO(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }

    /**
     * @param searchDto
     * @param page
     * @return
     */
    @Override
    public List<OrderFormDataDTO> findFinanceOrderFormDtoList(OrderFormSearchDTO searchDto, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select  o.delayPhoto,rep.reportStatus,p.province, " +
                " IFNULL((SELECT city FROM sys_region WHERE oid = a.city_id),'0') as city , " +
                " IFNULL((SELECT area FROM sys_region WHERE oid = a.area_id),'0') as area , " +
                " o.oid as orderId, a.oid as activityId,a.name as activityName, " +
                " a.activitySource, " +
                " a.gov, o.orderNo,DATE_FORMAT(a.orderDate,'%Y-%m-%d %H:%i:%s') AS orderDate,a.activityType,  " +
                " o.orderStatus,a.activityStatus," +
                " o.amount,IFNULL(o.refundAmount,0) as refundAmount,IFNULL(o.sourceAmount,0) as sourceAmount," +
                " off.payOrg,oo.name as orgName," +
                " org.name as pgOrgName,a.isVirtualContractor,a.sponsor,t.paymentMode,t.paymentType, " +
                " DATE_FORMAT(t.endTime,'%Y-%m-%d %H:%i:%s') AS payDate " +
                " from RISK_ACTIVITY a " +
                " inner join sys_region p on p.oid = a.province_id" +
                " inner join RISK_ORDERFORM o on o.activity_id = a.oid " +
                " inner join RISK_SE_USER u on o.user_id = u.oid " +
                " inner join risk_org oo on oo.oid = u.org_id " +
                " left join risk_transaction t on t.orderForm_id  = o.oid " +
                " left join risk_transactionoffline off on off.oid = t.oid " +
                " left join risk_report rep on rep.activity_id=a.oid " +
                " left join ( select A.activity_id,A.org_id,C.name from RISK_Activity_Cooper A,risk_serviceorg B,risk_org C " +
                " where B.serviceOrgType=1 and A.org_id=B.oid and A.org_id=C.oid ) org on a.oid=org.activity_id " +
                " WHERE EXISTS (SELECT 1 FROM risk_activity_cooper d ,risk_serviceOrg e " +
                " WHERE d.org_id = e.oid AND e.serviceOrgType = '1' AND d.activity_id = a.oid ) " +
                " and o.orderStatus != 9 and a.isBackup = 0 ";

        if (searchDto.getUser() != null) {
            if (searchDto.getUser().getOrg() != null) {
                //出纳账号显示所有机构数据
                if (!("chuna".equals(searchDto.getUser().getUserName())||("chunali".equals(searchDto.getUser().getUserName())))) {
                    sql = sql + " AND org.org_id  = " + searchDto.getUser().getOrg().getOid();
                }
            }
        }

        if (StringUtil.isNotEmpty(searchDto.getKeyname())) {
            sql = sql + " AND (a.name like '%" + searchDto.getKeyname() + "%' " +
                    " or org.name like '%" + searchDto.getKeyname() + "%' " +
                    " or a.sponsor like '%" + searchDto.getKeyname() + "%' " +
                    " or o.amount like '%" + searchDto.getKeyname() + "%' ) ";
        }
        if (StringUtil.isNotEmpty(searchDto.getOrderStatus())) {
            sql = sql + " AND o.orderStatus = " + searchDto.getOrderStatus() + " ";
        }
        if (StringUtil.isNotEmpty(searchDto.getStartDate())
                && StringUtil.isNotEmpty(searchDto.getEndDate())) {
            sql = sql + " AND a.orderDate between DATE_FORMAT('" + searchDto.getStartDate() + "','%Y-%m-%d %H:%i:%S') " +
                    " and DATE_FORMAT('" + cn.hutool.core.date.DateUtil.format(DomainDateUtil.addDay(DomainDateUtil.parseDate(searchDto.getEndDate()), 1), DatePattern.NORM_DATE_PATTERN) + "','%Y-%m-%d %H:%i:%S')";
        }
        if (StringUtil.isNotEmpty(searchDto.getProvince())) {
            sql = sql + " AND p.oid = " + searchDto.getProvince() + " ";
        }
        if (StringUtil.isNotEmpty(searchDto.getPayMethod())) {
            sql += " and t.paymentMode='" + searchDto.getPayMethod() + "' ";
        }
        if (StringUtil.isNotEmpty(searchDto.getPayBeginDate())) {
            sql += " and t.endTime >= '" + searchDto.getPayBeginDate() + "' ";
        }
        if (StringUtil.isNotEmpty(searchDto.getPayEndDate())) {
            sql += " and t.endTime <= '" + searchDto.getPayEndDate() + "' ";
        }

        //过滤演示数据
        if ("testchuna".equals(searchDto.getUser().getUserName())) {
            sql = sql + " and (u.userName = 'chengban' or u.userName = 'chanpinbu')";
        } else {
            sql = sql + " and (u.userName != 'chengban' and userName != 'chanpinbu')";
        }
        wrapper.orderBy("a.oid", false);
        List<OrderFormDataDTO> dtoList = Lists.newArrayList();
        Page<Map<String, Object>> pageList = queryMapsPage(sql, wrapper, page);
        List<Map<String, Object>> list = pageList.getRecords();
        list.forEach(result -> {
            OrderFormDataDTO dto = new OrderFormDataDTO(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }


    /**
     * 查找出纳订单的省份
     *
     * @param searchDto
     * @return
     */
    @Override
    public List<Map<String, Object>> findFinanceProvince(OrderFormSearchDTO searchDto) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select DISTINCT" +
                " p.oid,p.province \n" +
                " from RISK_ACTIVITY a  \n" +
                " inner join sys_region p on p.oid = a.province_id \n" +
                " inner join RISK_ORDERFORM o on o.activity_id = a.oid  \n" +
                " inner join RISK_SE_USER u on o.user_id = u.oid  \n" +
                " inner join risk_org oo on oo.oid = u.org_id  \n" +
                " left join risk_transaction t on t.orderForm_id  = o.oid  \n" +
                " left join risk_transactionoffline off on off.oid = t.oid  \n" +
                " WHERE EXISTS (SELECT 1 FROM risk_activity_cooper d ,risk_serviceOrg e  \n" +
                " WHERE d.org_id = e.oid AND e.serviceOrgType = '1' AND d.activity_id = a.oid )  \n" +
                " and o.orderStatus != 9 and a.isBackup = 0 ";
        //过滤演示数据
        if ("testchuna".equals(searchDto.getUser().getUserName())) {
            sql = sql + " and (u.userName = 'chengban' or u.userName = 'chanpinbu')";
        } else {
            sql = sql + " and (u.userName != 'chengban' and userName != 'chanpinbu')";
        }
        return queryMaps(sql, wrapper);
    }


    /**
     * 查找出纳订单的汇总
     *
     * @param searchDto
     * @return
     */
    @Override
    public Map<String, Object> findFinanceOrderFormSummary(OrderFormSearchDTO searchDto) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select " +
                " count(a.oid) 'elements', " +
                " sum(case when o.orderStatus = '0' then o.amount else 0 end) 'wzf', " +
                " sum(case when o.orderStatus = '1' then o.amount else 0 end) 'yzf', " +
                " sum(case when o.orderStatus = '4' then o.amount else 0 end) 'yhzf'," +
                " sum(o.amount) 'total'" +
                " from RISK_ACTIVITY a " +
                " inner join sys_region p on p.oid = a.province_id" +
                " inner join RISK_ORDERFORM o on o.activity_id = a.oid " +
                " inner join RISK_SE_USER u on o.user_id = u.oid " +
                " inner join risk_org oo on oo.oid = u.org_id " +
                " left join risk_transaction t on t.orderForm_id  = o.oid " +
                " left join risk_transactionoffline off on off.oid = t.oid " +
                " left join ( " +
                " select A.activity_id, A.org_id, C.name " +
                " from RISK_Activity_Cooper A,risk_serviceorg B,risk_org C " +
                "  where B.serviceOrgType=1 and A.org_id=B.oid and A.org_id=C.oid " +
                ") org on a.oid=org.activity_id " +
                " WHERE EXISTS (SELECT 1 FROM risk_activity_cooper d ,risk_serviceOrg e " +
                " WHERE d.org_id = e.oid AND e.serviceOrgType = '1' AND d.activity_id = a.oid ) " +
                " and o.orderStatus != " + DictConst.ORDERSTATUS_YSC + " and a.isBackup = 0  ";

        if (searchDto.getUser() != null) {
            if (searchDto.getUser().getOrg() != null) {
                //出纳账号显示所有机构数据
                if (!("chuna".equals(searchDto.getUser().getUserName())||("chunali".equals(searchDto.getUser().getUserName())))) {
                    sql = sql + " AND org.org_id  = " + searchDto.getUser().getOrg().getOid();
                }
            }
        }

        if (StringUtil.isNotEmpty(searchDto.getKeyname())) {

            sql = sql + " AND (a.name like '%" + searchDto.getKeyname() + "%' " +
                    " or org.name like '%" + searchDto.getKeyname() + "%' " +
                    " or a.sponsor like '%" + searchDto.getKeyname() + "%' " +
                    " or o.amount like '%" + searchDto.getKeyname() + "%' ) ";

        }
        if (StringUtil.isNotEmpty(searchDto.getOrderStatus())) {
            sql = sql + " AND o.orderStatus = " + searchDto.getOrderStatus() + " ";
        }


        if (StringUtil.isNotEmpty(searchDto.getStartDate())
                && StringUtil.isNotEmpty(searchDto.getEndDate())) {
            sql = sql + " AND a.orderDate between DATE_FORMAT('" + searchDto.getStartDate() + "','%Y-%m-%d %H:%i:%S') " +
                    " and DATE_FORMAT('" + cn.hutool.core.date.DateUtil.format(DomainDateUtil.addDay(DomainDateUtil.parseDate(searchDto.getEndDate()), 1), DatePattern.NORM_DATE_PATTERN) + "','%Y-%m-%d %H:%i:%S')";
        }
        if (StringUtil.isNotEmpty(searchDto.getProvince())) {
            sql = sql + " AND p.oid = " + searchDto.getProvince() + " ";
        }

        if (StringUtil.isNotEmpty(searchDto.getPayMethod())) {
            sql += " and t.paymentMode='" + searchDto.getPayMethod() + "' ";
        }
        if (StringUtil.isNotEmpty(searchDto.getPayBeginDate())) {
            sql += " and t.endTime >= '" + searchDto.getPayBeginDate() + "' ";
        }
        if (StringUtil.isNotEmpty(searchDto.getPayEndDate())) {
            sql += " and t.endTime <= '" + searchDto.getPayEndDate() + "' ";
        }

        //过滤演示数据
        if ("testchuna".equals(searchDto.getUser().getUserName())) {
            sql = sql + " and (u.userName = 'chengban' or u.userName = 'chanpinbu')";
        } else {
            sql = sql + " and (u.userName != 'chengban' and userName != 'chanpinbu')";
        }
        return queryMap(sql, wrapper);
    }


    /**
     * @param searchDto
     * @return
     */
    @Override
    public List<Map<String, Object>> findFinanceOrderFormExportList(OrderFormSearchDTO searchDto) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select o.orderNo '01',\n" +
                " CONCAT(p.province,c.city) '02',\n" +
                " a.name '03',\n" +
                " case when a.activitySource = 1 then '在线申报'\n" +
                " when a.activitySource = 2 then '系统录入' else '' end '0301',\n" +
                " a.sponsor '04',\n" +
                " a.orderDate '05',\n" +
                " o.amount '06',\n" +
                " case when o.orderStatus = 0 then '未支付'\n" +
                " when o.orderStatus = 1 then '已支付'\n" +
                " when o.orderStatus = 4 then '延后支付' else '' end '07',\n" +
                " case when t.paymentType = 4 then '联动优势'\n" +
                " when t.paymentType = 5 then '银行转账'\n" +
                " when t.paymentType = 6 then '现金' else '' end '08',\n" +
                " t.createOn '09',\n" +
                " off.payAccount '10',\n" +
                " off.payOrg '11',\n" +
                " case when ae.invoiceExpressMode = 1 then '普通发票'\n" +
                " when ae.invoiceExpressMode = 2 then '增值税发票' else '' end '12',\n" +
                " case when ae.invoiceExpressMode = 1 then ae.invoiceTitle" +
                " when ae.invoiceExpressMode = 2 then ae.companyNameInvoice else '' end as '13',\n" +
                " ae.taxpayerNumberInvoice '14',\n" +
                " ae.registerAddressInvoice '15',\n" +
                " ae.bankInvoice '16',\n" +
                " ae.bankAccountInvoice '17',\n" +
                " ae.ticketAddress '18' " +
                " from RISK_ACTIVITY a " +
                " inner join sys_region p on p.oid = a.province_id" +
                " inner join RISK_ORDERFORM o on o.activity_id = a.oid " +
                " inner join RISK_SE_USER u on o.user_id = u.oid " +
                " inner join risk_org oo on oo.oid = u.org_id " +
                " left join risk_transaction t on t.orderForm_id  = o.oid " +
                " left join risk_transactionoffline off on off.oid = t.oid " +
                " left join sys_region c on c.oid = a.city_id" +
                " left join risk_activityexpress ae on ae.orderForm_id = o.oid" +
                " inner join( " +
                " SELECT " +
                " distinct d.activity_id,o.oid,o.name " +
                " FROM " +
                " risk_activity_cooper d," +
                " risk_serviceOrg e," +
                " risk_org o " +
                " WHERE " +
                " d.org_id = e.oid " +
                " AND e.oid = o.oid " +
                " AND e.serviceOrgType = '1' " +
                ") K on K.activity_id=a.oid " +
                " where 1=1 " +
                " and o.orderStatus != 9 and a.isBackup = 0 ";

        if (searchDto.getUser() != null) {
            if (searchDto.getUser().getOrg() != null) {
                //出纳账号显示所有机构数据,风评机构显示所有
                if (!(("chuna".equals(searchDto.getUser().getUserName()))||("chunali".equals(searchDto.getUser().getUserName())))) {
                    sql = sql + " and k.oid = " + searchDto.getUser().getOrg().getOid();
                }
            }
        }

        if (StringUtil.isNotEmpty(searchDto.getKeyname())) {
            sql = sql + " AND ( a.name like '%" + searchDto.getKeyname() + "%' or a.sponsor like '%" + searchDto.getKeyname() + "%' or K.name like '%" + searchDto.getKeyname() + "%' )";
        }
        if (StringUtil.isNotEmpty(searchDto.getOrderStatus())) {
            sql = sql + " AND o.orderStatus = " + searchDto.getOrderStatus() + " ";
        }
        if (StringUtil.isNotEmpty(searchDto.getAmount())) {
            sql += " and o.amount like '%" + searchDto.getAmount() + "%' ";
        }
        if (StringUtil.isNotEmpty(searchDto.getStartDate())
                && StringUtil.isNotEmpty(searchDto.getEndDate())) {
            sql = sql + " AND a.orderDate between DATE_FORMAT('" + searchDto.getStartDate() + "','%Y-%m-%d %H:%i:%S') " +
                    " and DATE_FORMAT('" + cn.hutool.core.date.DateUtil.format(DomainDateUtil.addDay(DomainDateUtil.parseDate(searchDto.getEndDate()), 1), DatePattern.NORM_DATE_PATTERN) + "','%Y-%m-%d %H:%i:%S')";
        }
        if (StringUtil.isNotEmpty(searchDto.getProvince())) {
            sql = sql + " AND p.oid = " + searchDto.getProvince() + " ";
        }

        if (StringUtil.isNotEmpty(searchDto.getPayMethod())) {
            sql += " and t.paymentMode='" + searchDto.getPayMethod() + "' ";
        }
        if (StringUtil.isNotEmpty(searchDto.getPayBeginDate())) {
            sql += " and t.endTime >='" + searchDto.getPayBeginDate() + "' ";
        }
        if (StringUtil.isNotEmpty(searchDto.getPayEndDate())) {
            sql += " and t.endTime <='" + searchDto.getPayEndDate() + "' ";
        }

        //过滤演示数据
        if ("testchuna".equals(searchDto.getUser().getUserName())) {
            sql = sql + " and (u.userName = 'chengban' or u.userName = 'chanpinbu')";
        } else {
            sql = sql + " and (u.userName != 'chengban' and userName != 'chanpinbu')";
        }
        wrapper.orderBy("a.oid", false);
        return queryMaps(sql, wrapper);
    }


    @Override
    public List<OrderFormDataDTO> findOrderFormDtoList(OrderFormSearchDTO searchDto, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select " +
                " IFNULL(o.refundAmount,0) as refundAmount, " +
                " t.paymentMode," +
                " o.oid as orderId," +
                " a.isBackUp," +
                " a.oid as activityId," +
                " a.name as activityName," +
                " a.activitySource," +
                " o.orderNo," +
                " DATE_FORMAT(a.orderDate,'%Y-%m-%d %H:%i:%s') AS orderDate," +
                " a.activityType, " +
                " i.alias, " +
                " o.orderStatus," +
                " a.activityStatus," +
                " '' as approvalStatus," +
//                " IF((select count(1) from sys_marketregion where oid=a.province_id and independent='1')>0,a.approvalStatus,'') as approvalStatus," +
                " r.reportStatus," +
                " '' as sbApprovalStatus," +
//                " IF((select count(1) from sys_marketregion where oid=a.province_id and independent='1')>0,a.sbApprovalStatus,'') as sbApprovalStatus," +
                " a.primaryStatus," +
                " o.amount," +
                " a.gov," +
                " a.province_id as province," +
                " (SELECT COUNT(1) " +
                "  FROM risk_activity_cooper b,risk_serviceOrg c " +
                "  WHERE b.org_id = c.oid " +
                " AND c.serviceOrgType = '" + DictConst.SERVICEORGTYPE_FXPGJG + "' " +
                " AND b.activity_id = a.oid ) AS pgjgCount, " +
                "(select oid as taskId from risk_task where taskType=2 and activity_id=A.oid and assgin_id is not null limit 1) as taskId " +
                " from RISK_ACTIVITY a " +
                " inner join RISK_ORDERFORM o on o.activity_id = a.oid " +
                " inner join RISK_report r on r.activity_id = a.oid " +
                " inner join RISK_SE_USER u on o.user_id = u.oid " +
                " inner join sys_region i on i.oid = a.area_id " +
                " left join risk_transaction t on t.orderForm_id  = o.oid ";
        /* 过滤报备的政府活动 */
//        wrapper.eq("a.isBackup",DictConst.N);
        // 许可项目或者需要风评报告的
        wrapper.where(" (a.isBackup=0 or a.needReport=1) ");
        wrapper.notIn("o.orderStatus", DictConst.ORDERSTATUS_YSC);

        // 是否申报活动
        if (StringUtil.isNotEmpty(searchDto.getIsShenBao())) {
            wrapper.eq("a.isShenBao", searchDto.getIsShenBao());
        }
        if (searchDto.getUser() != null) {
            wrapper.eq("u.oid", searchDto.getUser().getOid());
        }
        if (StringUtil.isNotEmpty(searchDto.getKeyname())) {
            wrapper.like("a.name", searchDto.getKeyname());
        }
        if (searchDto.getProcess().equalsIgnoreCase(DictConst.Y)) {
            wrapper.notIn("a.activityStatus", DictConst.ACTIVITYSTATUS_HDJS);
        }
        if (searchDto.getProcess().equalsIgnoreCase(DictConst.N)) {
            wrapper.eq("a.activityStatus", DictConst.ACTIVITYSTATUS_HDJS);
        }
        if (StringUtil.isNotEmpty(searchDto.getOrderStatus())) {
            if (DictConst.ACTIVITYSTATUS_HDJS.equals(searchDto.getOrderStatus())) {
                wrapper.eq("a.activityStatus", DictConst.ACTIVITYSTATUS_HDJS);
            } else {
                wrapper.notIn("a.activityStatus", DictConst.ACTIVITYSTATUS_HDJS);
                wrapper.eq("o.orderStatus", searchDto.getOrderStatus());
            }
        }
        if (StringUtil.isNotEmpty(searchDto.getActivitySource())) {
            wrapper.eq("a.activitySource", searchDto.getActivitySource());
        }
        if (DictConst.ACTIVITY_SORTVALUE_1.equals(searchDto.getSortValue())) {
            wrapper.orderBy(" a.startDate", true);
        }else if (DictConst.ACTIVITY_SORTVALUE_2.equals(searchDto.getSortValue())) {
            wrapper.orderBy(" a.startDate", false);
        }else if (DictConst.ACTIVITY_SORTVALUE_3.equals(searchDto.getSortValue())) {
            wrapper.orderBy(" a.createOn", true);
        }else if (DictConst.ACTIVITY_SORTVALUE_4.equals(searchDto.getSortValue())) {
            wrapper.orderBy(" a.createOn", false);
        }else{
            wrapper.orderBy(" a.createOn", false);
        }
        List<OrderFormDataDTO> dtoList = Lists.newArrayList();
        Page<Map<String, Object>> pageList = queryMapsPage(sql, wrapper, page);
        List<Map<String, Object>> list = pageList.getRecords();
        list.forEach(result -> {
            OrderFormDataDTO dto = new OrderFormDataDTO(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }


    @Override
    public List<OrderFormDataDTO> findServiceOrderList(OrderFormSearchDTO searchDto, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select " +
                " o.oid as orderId," +
                " a.oid as activityId," +
                " a.name as activityName," +
                " a.activitySource," +
                " so.serviceOrgType" +
                " , o.orderNo,DATE_FORMAT(a.orderDate,'%Y-%m-%d %H:%i:%s') AS orderDate,a.activityType,o.orderStatus" +
                " ,a.activityStatus,o.reportAmount as reportAmount,o.discountAmount as discountAmount,o.amount as total,ac.amount ,a.gov,IFNULL(a.chooseAssess,'1') AS chooseAssess " +
                " from " + TableConst.ACTIVITY_TABLE + " a " +
                " inner join " + TableConst.ORDERFORM_TABLE + " o on o.activity_id = a.oid " +
                " inner join " + TableConst.ACTIVITYCOOPER_TABLE + " ac on ac.activity_id = a.oid " +
                " inner join " + TableConst.SERIVICEORG_TABLE + " so on so.oid = ac.org_id ";
        /* 过滤报备的政府活动 */
        wrapper.eq("a.isBackup", DictConst.N);
        /* 过滤已删除的活动 */
        wrapper.notIn("o.orderStatus", DictConst.ORDERSTATUS_YSC);
        if (searchDto.getOrg() != null) {
            wrapper.eq("ac.org_id", searchDto.getOrg().getOid());
        }
        if (searchDto.getProcess().equalsIgnoreCase(DictConst.Y)) {
            wrapper.notIn("a.activityStatus", "50");
        }
        if (searchDto.getProcess().equalsIgnoreCase(DictConst.N)) {
            wrapper.eq("a.activityStatus", "50");
        }
        if (StringUtil.isNotEmpty(searchDto.getKeyname())) {
            wrapper.like("a.name", searchDto.getKeyname());
        }
        if (StringUtil.isNotEmpty(searchDto.getActivityStatus())) {
            if (searchDto.getActivityStatus().equalsIgnoreCase("0")
                    || searchDto.getActivityStatus().equalsIgnoreCase("1")) {
                wrapper.eq("o.orderStatus", searchDto.getActivityStatus());
            } else if ("4".equals(searchDto.getActivityStatus())) {
                wrapper.eq("o.orderStatus", searchDto.getActivityStatus());
            } else {
                Object[] o = new Object[2];
                o[0] = new String("0");
                o[1] = new String("2");
                wrapper.eq("a.activityStatus", searchDto.getActivityStatus());
                wrapper.notIn("o.orderStatus", o);
            }
        }
        wrapper.orderBy("a.oid", false);
        List<OrderFormDataDTO> dtoList = Lists.newArrayList();
        Page<Map<String, Object>> pageList = queryMapsPage(sql, wrapper, page);
        List<Map<String, Object>> list = pageList.getRecords();
        list.forEach(result -> {
            OrderFormDataDTO dto = new OrderFormDataDTO(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }

    @Override
    public OrderForm findOrderFormByAcivity(Activity activity) {
        List<Criterion> criterionList = Lists.newArrayList();
        if (activity != null) {

            criterionList.add(Restrictions.eq("activity", activity));
        }
        return selectOne(criterionList);
    }


    @Override
    public List<OrderFormDataDTO> queryOrderDetail(OrderForm orderForm) {
        String sql = "SELECT m.amount," +
                "            m.fyxm," +
                "            m.name," +
                "            m.contactName," +
                "            m.contactPhone" +
                "     FROM " +
                "       (SELECT a.discountAmount AS amount," +
                "              '风险评估报告费用' AS fyxm," +
                "              (SELECT d.name" +
                "                 FROM risk_activity_cooper b , risk_serviceorg c ,risk_org d " +
                "                WHERE b.org_id = c.oid " +
                "                  AND c.oid = d.oid" +
                "                  AND c.serviceOrgType = '1'" +
                "                  AND b.activity_id = a.activity_id) AS name," +
                "              (SELECT c.contactName" +
                "                 FROM risk_activity_cooper b , risk_serviceorg c" +
                "                WHERE b.org_id = c.oid " +
                "                  AND c.serviceOrgType = '1'" +
                "                  AND b.activity_id = a.activity_id) AS contactName ," +
                "              (SELECT c.contactPhone" +
                "                 FROM risk_activity_cooper b , risk_serviceorg c " +
                "                WHERE b.org_id = c.oid " +
                "                  AND c.serviceOrgType = '1'" +
                "                  AND b.activity_id = a.activity_id) AS contactPhone " +
                "          FROM risk_orderform a" +
                "         WHERE IFNULL(a.discountAmount,0)>0" +
                "           AND a.oid = " + orderForm.getOid() +
                "      UNION " +
                "       SELECT a.contractAmount AS amount," +
                "              '合同认证费用' AS fyxm," +
                "               NULL AS name," +
                "               NULL AS contactName ," +
                "               NULL AS contactPhone " +
                "         FROM risk_orderform a" +
                "        WHERE IFNULL(a.contractAmount,0)>0" +
                "          AND a.oid = " + orderForm.getOid() +
                "      UNION " +
                "       SELECT a.monitorAmount AS amount," +
                "              '视频监控费用' AS fyxm," +
                "               NULL AS name," +
                "               NULL AS contactName ," +
                "               NULL AS contactPhone" +
                "         FROM risk_orderform a" +
                "        WHERE IFNULL(a.monitorAmount,0)>0" +
                "          AND a.oid = " + orderForm.getOid() +
                "      UNION " +
                "       SELECT a.supplyAmount AS amount," +
                "              '补充费用' AS fyxm," +
                "               NULL AS name," +
                "               NULL AS contactName ," +
                "               NULL AS contactPhone" +
                "         FROM risk_orderform a" +
                "        WHERE IFNULL(a.supplyAmount,0)>0" +
                "          AND a.oid = " + orderForm.getOid() + " ) m ";
        List<OrderFormDataDTO> dtoList = Lists.newArrayList();
        List<Map<String, Object>> pageList = queryMaps(sql);
        pageList.forEach(result -> {
            OrderFormDataDTO dto = new OrderFormDataDTO(result);
            dtoList.add(dto);
        });
        return dtoList;
    }

    /**
     * 查找已支付、未同步或者同步失败的订单
     *
     * @return
     */

    @Override
    public List<OrderForm> queryNeedSyncOrder() {
        List<Criterion> criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.or(Restrictions.eq("isSync", DictConst.N), Restrictions.isNull("isSync")));
        criterionList.add(Restrictions.eq("orderStatus", DictConst.ORDERSTATUS_YZF));
        Order order = Order.desc("oid");
        return selectList(criterionList, order);
    }


    /**
     * 管理-活动列表（全）
     *
     * @param searchDto
     * @param page
     * @return
     */
    @Override
    public List manageActivityList(OrderFormSearchDTO searchDto, DwzPage page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select p.province,sr1.city,sr2.area, o.oid as orderId, " +
                " a.oid as activityId,a.name as activityName, " +
                " a.activitySource, " +
                " a.approveOrg as approvalUnit, " +
                " o.orderNo,DATE_FORMAT(a.createOn,'%Y-%m-%d %H:%i:%s') AS createOn," +
                " DATE_FORMAT(a.orderDate,'%Y-%m-%d %H:%i:%s') AS orderDate, " +
                " a.address ,DATE_FORMAT(a.updateOn,'%Y-%m-%d %H:%i:%s') AS updateOn ," +
                " a.activityType ,o.orderStatus,a.activityStatus,a.approvalStatus," +
                " a.sbApprovalStatus," +
                " sd.label as activityStatusName,o.amount, " +
                " DATE_FORMAT(a.startDate,'%Y-%m-%d %H:%i:%s') AS startDate," +
                " DATE_FORMAT(a.endDate,'%Y-%m-%d %H:%i:%s') AS endDate, " +
                " a.sponsor, if(timeStampDiff(DAY, NOW(), startDate)>0," +
                " timeStampDiff(DAY, NOW(), startDate),'') AS dateFrom ,b.paymentMode " +
                " from RISK_ACTIVITY a " +
                " inner join RISK_ORDERFORM o on o.activity_id = a.oid " +
                " inner join sys_region p on p.oid = a.province_id" +
                " inner join RISK_SE_USER u on o.user_id = u.oid " +
                " inner JOIN sys_region sr1 ON sr1.oid = a.city_id " +
                " LEFT JOIN sys_region sr2 ON sr2.oid = a.area_id " +
                " INNER JOIN sys_dict sd on sd.`value`= a.activityStatus and sd.type='activityStatus'" +
                " LEFT JOIN risk_transaction b on b.orderNo = o.orderNo and b.payStatus='1'" +
                " where 1=1 " +
                " and o.orderStatus != '" + DictConst.ORDERSTATUS_YSC + "' ";

        if (StringUtil.isNotEmpty(searchDto.getStartDate())) {
            sql = sql + " AND DATE_FORMAT(a.startDate,'%Y-%m-%d') >= '" + searchDto.getStartDate() + "' ";
        }
        //活动开始时间结束
        if (StringUtil.isNotEmpty(searchDto.getEndDate())) {
            sql = sql + " AND DATE_FORMAT(a.startDate,'%Y-%m-%d') <= '" + searchDto.getEndDate() + "' ";
        }
        //活动结束时间起始
        if (StringUtil.isNotEmpty(searchDto.getEndDate1())) {
            sql = sql + " AND DATE_FORMAT(a.endDate,'%Y-%m-%d') >= '" + searchDto.getEndDate1() + "' ";
        }
        //活动结束时间终止
        if (StringUtil.isNotEmpty(searchDto.getEndDate2())) {
            sql = sql + " AND DATE_FORMAT(a.endDate,'%Y-%m-%d') <= '" + searchDto.getEndDate2() + "' ";
        }
        //下单日期起始
        if (StringUtil.isNotEmpty(searchDto.getOrderDateStart())) {
            sql = sql + " AND DATE_FORMAT(a.orderDate,'%Y-%m-%d') >= '" + searchDto.getOrderDateStart() + "' ";
        }
        //下单日期结束
        if (StringUtil.isNotEmpty(searchDto.getOrderDateEnd())) {
            sql = sql + " AND DATE_FORMAT(a.orderDate,'%Y-%m-%d') <= '" + searchDto.getOrderDateEnd() + "' ";
        }
        //活动创建时间
        if (StringUtil.isNotEmpty(searchDto.getCreateDateStart())) {
            sql = sql + " AND DATE_FORMAT(a.createOn,'%Y-%m-%d') >= '" + searchDto.getCreateDateStart() + "' ";
        }
        //活动创建时间
        if (StringUtil.isNotEmpty(searchDto.getCreateDateEnd())) {
            sql = sql + " AND DATE_FORMAT(a.createOn,'%Y-%m-%d') <= '" + searchDto.getCreateDateEnd() + "' ";
        }
        //活动来源
        if (StringUtil.isNotEmpty(searchDto.getActivitySource())) {
            sql = sql + " AND a.activitySource = '" + searchDto.getActivitySource() + "' ";
        }
        //活动类型
        if (StringUtil.isNotEmpty(searchDto.getActivityType())) {
            sql = sql + " AND a.activityType = '" + searchDto.getActivityType() + "' ";
        }
        //活动状态
        if (StringUtil.isNotEmpty(searchDto.getActivityStatus())) {
            sql = sql + " AND a.activityStatus = '" + searchDto.getActivityStatus() + "' ";
        }
        //审批状态
        if (StringUtil.isNotEmpty(searchDto.getSbApprovalStatus())) {
            sql = sql + " AND a.sbApprovalStatus = '" + searchDto.getSbApprovalStatus() + "' ";
        }
        //订单状态
        if (StringUtil.isNotEmpty(searchDto.getOrderStatus())) {
            sql = sql + " AND o.orderStatus = '" + searchDto.getOrderStatus() + "' ";
        }
        //支付方式
        if (StringUtil.isNotEmpty(searchDto.getPayMethod())) {
            sql = sql + "  AND b.paymentMode  = '" + searchDto.getPayMethod() + "' ";
        }

        //关键词搜索范围：承办单位名称、活动名称、举办地址，并支持模糊搜索
        if (StringUtil.isNotEmpty(searchDto.getKeyWord())) {
            sql = sql + " AND ( a.sponsor like '%" + searchDto.getKeyWord() + "%' " +
                    "OR  a.`name` LIKE '%" + searchDto.getKeyWord() + "%' OR a.address LIKE '%" + searchDto.getKeyWord() + "%')";
        }
        //活动城市
        if (StringUtil.isNotEmpty(searchDto.getProvinceId())) {
            sql = sql + " AND a.province_id = '" + searchDto.getProvinceId() + "' ";
        }
        //活动城市
        if (StringUtil.isNotEmpty(searchDto.getCityId())) {
            sql = sql + " AND a.city_id = '" + searchDto.getCityId() + "' ";
        }
        //活动城市
        if (StringUtil.isNotEmpty(searchDto.getAreaId())) {
            sql = sql + " AND a.area_id = '" + searchDto.getAreaId() + "' ";
        }
        //许可单位
        if (StringUtil.isNotEmpty(searchDto.getApprovalUnit())) {
            sql = sql + " AND sr3.area like '%" + searchDto.getApprovalUnit() + "%' ";
        }
        if (page != null) {
            page.setTotalCount(querySqlCounts(sql, wrapper));
            sql += getOrderTypeSql(searchDto.getSortValue());
            sql = sql + " limit " + (page.getPageNum() - 1) * page.getNumPerPage() + "," + page.getNumPerPage();
        }
        return queryMaps(sql, wrapper);
    }


    @Override
    public List manageOrderList(OrderFormSearchDTO searchDto, DwzPage page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select p.province,sr1.city,sr2.area, o.oid as orderId, " +
                " a.oid as activityId,a.name as activityName, " +
                " a.activitySource, " +
                " a.approveOrg as approvalUnit, " +
                " o.orderNo,DATE_FORMAT(a.createOn,'%Y-%m-%d %H:%i:%s') AS createOn," +
                " DATE_FORMAT(a.activityDate,'%Y-%m-%d %H:%i:%s') AS activityDate, " +
                " DATE_FORMAT(a.orderDate,'%Y-%m-%d %H:%i:%s') AS orderDate, " +
                " a.address ,DATE_FORMAT(a.updateOn,'%Y-%m-%d %H:%i:%s') AS updateOn ," +
                " a.activityType ,o.orderStatus,a.activityStatus,a.approvalStatus," +
                " a.sbApprovalStatus," +
                " sd.label as activityStatusName,o.amount, " +
                " DATE_FORMAT(a.startDate,'%Y-%m-%d %H:%i:%s') AS startDate," +
                " DATE_FORMAT(a.endDate,'%Y-%m-%d %H:%i:%s') AS endDate, " +
                " a.sponsor, if(timeStampDiff(DAY, NOW(), startDate)>0," +
                " timeStampDiff(DAY, NOW(), startDate),'') AS dateFrom ,b.paymentMode " +
                " from RISK_ACTIVITY a " +
                " inner join RISK_ORDERFORM o on o.activity_id = a.oid " +
                " inner join sys_region p on p.oid = a.province_id" +
                " inner join RISK_SE_USER u on o.user_id = u.oid " +
                " inner JOIN sys_region sr1 ON sr1.oid = a.city_id " +
                " LEFT JOIN sys_region sr2 ON sr2.oid = a.area_id " +
                " INNER JOIN sys_dict sd on sd.`value`= a.activityStatus and sd.type='activityStatus'" +
                " LEFT JOIN risk_transaction b on b.orderNo = o.orderNo and b.payStatus='1'" +
                " where 1=1 " +
                " and o.orderStatus != '" + DictConst.ORDERSTATUS_YSC + "' " +
                " and a.activitySource != " + DictConst.ACTIVITYSOURCE_XTLR +
                " and a.gov != 1 " +
                " and a.isBackUp != 1 ";

        if (StringUtil.isNotEmpty(searchDto.getStartDate())) {
            sql = sql + " AND DATE_FORMAT(a.startDate,'%Y-%m-%d') >= '" + searchDto.getStartDate() + "' ";
        }
        //活动开始时间结束
        if (StringUtil.isNotEmpty(searchDto.getEndDate())) {
            sql = sql + " AND DATE_FORMAT(a.startDate,'%Y-%m-%d') <= '" + searchDto.getEndDate() + "' ";
        }
        //活动结束时间起始
        if (StringUtil.isNotEmpty(searchDto.getEndDate1())) {
            sql = sql + " AND DATE_FORMAT(a.endDate,'%Y-%m-%d') >= '" + searchDto.getEndDate1() + "' ";
        }
        //活动结束时间终止
        if (StringUtil.isNotEmpty(searchDto.getEndDate2())) {
            sql = sql + " AND DATE_FORMAT(a.endDate,'%Y-%m-%d') <= '" + searchDto.getEndDate2() + "' ";
        }
        //下单日期起始
        if (StringUtil.isNotEmpty(searchDto.getOrderDateStart())) {
            sql = sql + " AND DATE_FORMAT(a.orderDate,'%Y-%m-%d') >= '" + searchDto.getOrderDateStart() + "' ";
        }
        //下单日期结束
        if (StringUtil.isNotEmpty(searchDto.getOrderDateEnd())) {
            sql = sql + " AND DATE_FORMAT(a.orderDate,'%Y-%m-%d') <= '" + searchDto.getOrderDateEnd() + "' ";
        }
        //活动创建时间
        if (StringUtil.isNotEmpty(searchDto.getCreateDateStart())) {
            sql = sql + " AND DATE_FORMAT(a.createOn,'%Y-%m-%d') >= '" + searchDto.getCreateDateStart() + "' ";
        }
        //活动创建时间
        if (StringUtil.isNotEmpty(searchDto.getCreateDateEnd())) {
            sql = sql + " AND DATE_FORMAT(a.createOn,'%Y-%m-%d') <= '" + searchDto.getCreateDateEnd() + "' ";
        }
        //活动类型
        if (StringUtil.isNotEmpty(searchDto.getActivityType())) {
            sql = sql + " AND a.activityType = '" + searchDto.getActivityType() + "' ";
        }

        //活动状态
        if (StringUtil.isNotEmpty(searchDto.getActivityStatus())) {
            sql = sql + " AND a.activityStatus = '" + searchDto.getActivityStatus() + "' ";
        }
        //审批状态
        if (StringUtil.isNotEmpty(searchDto.getSbApprovalStatus())) {
            sql = sql + " AND a.sbApprovalStatus = '" + searchDto.getSbApprovalStatus() + "' ";
        }
        //订单状态
        if (StringUtil.isNotEmpty(searchDto.getOrderStatus())) {
            sql = sql + " AND o.orderStatus = '" + searchDto.getOrderStatus() + "' ";
        }
        //支付方式
        if (StringUtil.isNotEmpty(searchDto.getPayMethod())) {
            sql = sql + "  AND b.paymentMode  = '" + searchDto.getPayMethod() + "' ";
        }

        //关键词搜索范围：承办单位名称、活动名称、举办地址，并支持模糊搜索
        if (StringUtil.isNotEmpty(searchDto.getKeyWord())) {
            sql = sql + " AND ( a.sponsor like '%" + searchDto.getKeyWord() + "%' " +
                    "OR  a.`name` LIKE '%" + searchDto.getKeyWord() + "%' OR a.address LIKE '%" + searchDto.getKeyWord() + "%')";
        }
        //活动城市
        if (StringUtil.isNotEmpty(searchDto.getProvinceId())) {
            sql = sql + " AND a.province_id = '" + searchDto.getProvinceId() + "' ";
        }
        //活动城市
        if (StringUtil.isNotEmpty(searchDto.getCityId())) {
            sql = sql + " AND a.city_id = '" + searchDto.getCityId() + "' ";
        }
        //活动城市
        if (StringUtil.isNotEmpty(searchDto.getAreaId())) {
            sql = sql + " AND a.area_id = '" + searchDto.getAreaId() + "' ";
        }
        //许可单位
        if (StringUtil.isNotEmpty(searchDto.getApprovalUnit())) {
            sql = sql + " AND sr3.area like '%" + searchDto.getApprovalUnit() + "%' ";
        }
        if (page != null) {
            page.setTotalCount(querySqlCounts(sql, wrapper));

            sql += getOrderTypeSql(searchDto.getSortValue());

            sql = sql + " limit " + (page.getPageNum() - 1) * page.getNumPerPage() + "," + page.getNumPerPage();
        }
        return queryMaps(sql, wrapper);
    }


    /**
     * 许可列表
     *
     * @param searchDto
     * @param page
     * @return
     */
    @Override
    public List manageBusinessList(OrderFormSearchDTO searchDto, DwzPage page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT p.province,sr1.city,sr2.area,a.oid AS activityId," +
                " a.NAME AS activityName," +
                " a.activitySource," +
                " a.approveOrg as approvalUnit," +
                " DATE_FORMAT(a.activityDate,'%Y-%m-%d %H:%i:%s') AS activityDate," +
                " DATE_FORMAT(a.orderDate,'%Y-%m-%d %H:%i:%s') AS orderDate," +
                " a.address,DATE_FORMAT(a.updateOn,'%Y-%m-%d %H:%i:%s') AS updateOn,a.activityType," +
                " a.activityStatus,sd.label as activityStatusName,a.sbApprovalStatus,DATE_FORMAT(a.startDate,'%Y-%m-%d %H:%i:%s') AS startDate," +
                " DATE_FORMAT(a.endDate,'%Y-%m-%d %H:%i:%s') AS endDate,a.sponsor," +
                " if(timeStampDiff(DAY, NOW(), startDate)>0,timeStampDiff(DAY, NOW(), startDate),'') AS dateFrom " +
                " FROM RISK_ACTIVITY a " +
                " INNER JOIN risk_orderForm o ON a.oid = o.activity_id " +
                " INNER JOIN sys_region p ON p.oid = a.province_id " +
                " LEFT JOIN sys_region sr1 ON sr1.oid = a.city_id " +
                " LEFT JOIN sys_region sr2 ON sr2.oid = a.area_id " +
                " INNER JOIN sys_dict sd on sd.`value`= a.activityStatus and sd.type='activityStatus'" +
                " and a.gov != 1 " +
                " and a.isBackUp != 1 " +
                " AND o.orderStatus != '" + DictConst.ORDERSTATUS_YSC + "'";

        //活动开始时间起始
        if (StringUtil.isNotEmpty(searchDto.getStartDate())) {
            sql = sql + " AND DATE_FORMAT(a.startDate,'%Y-%m-%d') >= '" + searchDto.getStartDate() + "' ";
        }
        //活动开始时间结束
        if (StringUtil.isNotEmpty(searchDto.getEndDate())) {
            sql = sql + " AND DATE_FORMAT(a.startDate,'%Y-%m-%d') <= '" + searchDto.getEndDate() + "' ";
        }
        //活动结束时间起始
        if (StringUtil.isNotEmpty(searchDto.getEndDate1())) {
            sql = sql + " AND DATE_FORMAT(a.endDate,'%Y-%m-%d') >= '" + searchDto.getEndDate1() + "' ";
        }
        //活动结束时间终止
        if (StringUtil.isNotEmpty(searchDto.getEndDate2())) {
            sql = sql + " AND DATE_FORMAT(a.endDate,'%Y-%m-%d') <= '" + searchDto.getEndDate2() + "' ";
        }
        //下单日期起始
        if (StringUtil.isNotEmpty(searchDto.getOrderDateStart())) {
            sql = sql + " AND DATE_FORMAT(a.orderDate,'%Y-%m-%d') >= '" + searchDto.getOrderDateStart() + "' ";
        }
        //下单日期结束
        if (StringUtil.isNotEmpty(searchDto.getOrderDateEnd())) {
            sql = sql + " AND DATE_FORMAT(a.orderDate,'%Y-%m-%d') <= '" + searchDto.getOrderDateEnd() + "' ";
        }
        //活动创建时间
        if (StringUtil.isNotEmpty(searchDto.getCreateDateStart())) {
            sql = sql + " AND DATE_FORMAT(a.createOn,'%Y-%m-%d') >= '" + searchDto.getCreateDateStart() + "' ";
        }
        //活动创建时间
        if (StringUtil.isNotEmpty(searchDto.getCreateDateEnd())) {
            sql = sql + " AND DATE_FORMAT(a.createOn,'%Y-%m-%d') <= '" + searchDto.getCreateDateEnd() + "' ";
        }
        //活动类型
        if (StringUtil.isNotEmpty(searchDto.getActivityType())) {
            sql = sql + " AND a.activityType = '" + searchDto.getActivityType() + "' ";
        }

        //活动状态
        if (StringUtil.isNotEmpty(searchDto.getActivityStatus())) {
            sql = sql + " AND a.activityStatus = '" + searchDto.getActivityStatus() + "' ";
        }
        //审批状态
        if (StringUtil.isNotEmpty(searchDto.getSbApprovalStatus())) {
            sql = sql + " AND a.sbApprovalStatus = '" + searchDto.getSbApprovalStatus() + "' ";
        }
        //关键词搜索范围：承办单位名称、活动名称、举办地址，并支持模糊搜索
        if (StringUtil.isNotEmpty(searchDto.getKeyWord())) {
            sql = sql + " AND ( a.sponsor like '%" + searchDto.getKeyWord() + "%' " +
                    "OR  a.`name` LIKE '%" + searchDto.getKeyWord() + "%' OR a.address LIKE '%" + searchDto.getKeyWord() + "%')";
        }
        //活动城市
        if (StringUtil.isNotEmpty(searchDto.getProvinceId())) {
            sql = sql + " AND a.province_id = '" + searchDto.getProvinceId() + "' ";
        }
        //活动城市
        if (StringUtil.isNotEmpty(searchDto.getCityId())) {
            sql = sql + " AND a.city_id = '" + searchDto.getCityId() + "' ";
        }
        //活动城市
        if (StringUtil.isNotEmpty(searchDto.getAreaId())) {
            sql = sql + " AND a.area_id = '" + searchDto.getAreaId() + "' ";
        }
        //许可单位
        if (StringUtil.isNotEmpty(searchDto.getApprovalUnit())) {
            sql = sql + " AND sr3.area like '%" + searchDto.getApprovalUnit() + "%' ";
        }

        if (page != null) {
            page.setTotalCount(querySqlCounts(sql, wrapper));
            sql += getOrderTypeSql(searchDto.getSortValue());
            sql = sql + " limit " + (page.getPageNum() - 1) * page.getNumPerPage() + "," + page.getNumPerPage();
        }
        return queryMaps(sql, wrapper);
    }


    @Override
    public List manageGovActivityList(OrderFormSearchDTO searchDto, DwzPage page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT p.province,sr1.city,sr2.area,a.oid AS activityId," +
                " a.approveOrg as approvalUnit, " +
                " a. NAME AS activityName,DATE_FORMAT(a.createOn,'%Y-%m-%d %H:%i:%s') AS activityDate," +
                " a.address,DATE_FORMAT(a.updateOn,'%Y-%m-%d %H:%i:%s') AS updateOn,a.activityType," +
                " a.activityStatus,sd.label as activityStatusName,DATE_FORMAT(a.startDate,'%Y-%m-%d %H:%i:%s') AS startDate," +
                " DATE_FORMAT(a.endDate,'%Y-%m-%d %H:%i:%s') AS endDate,a.sponsor," +
                " DATE_FORMAT(a.orderDate,'%Y-%m-%d %H:%i:%s') AS orderDate," +
                " if(timeStampDiff(DAY, NOW(), startDate)>0,timeStampDiff(DAY, NOW(), startDate),'') AS dateFrom, " +
                " a.isBackup " +
                " FROM RISK_ACTIVITY a " +
                " INNER JOIN risk_orderForm o ON a.oid = o.activity_id " +
                " INNER JOIN sys_region p ON p.oid = a.province_id " +
                " LEFT JOIN sys_region sr1 ON sr1.oid = a.city_id " +
                " LEFT JOIN sys_region sr2 ON sr2.oid = a.area_id " +
                " INNER JOIN sys_dict sd on sd.`value`= a.activityStatus and sd.type='activityStatus'" +
                " where a.gov = '1' and a.isBackup = 1 " +
                " AND o.orderStatus != '" + DictConst.ORDERSTATUS_YSC + "' ";

        //活动开始时间起始
        if (StringUtil.isNotEmpty(searchDto.getStartDate())) {
            sql = sql + " AND DATE_FORMAT(a.startDate,'%Y-%m-%d') >= '" + searchDto.getStartDate() + "' ";
        }
        //活动开始时间结束
        if (StringUtil.isNotEmpty(searchDto.getEndDate())) {
            sql = sql + " AND DATE_FORMAT(a.startDate,'%Y-%m-%d') <= '" + searchDto.getEndDate() + "' ";
        }
        //活动结束时间起始
        if (StringUtil.isNotEmpty(searchDto.getEndDate1())) {
            sql = sql + " AND DATE_FORMAT(a.endDate,'%Y-%m-%d') >= '" + searchDto.getEndDate1() + "' ";
        }
        //活动结束时间终止
        if (StringUtil.isNotEmpty(searchDto.getEndDate2())) {
            sql = sql + " AND DATE_FORMAT(a.endDate,'%Y-%m-%d') <= '" + searchDto.getEndDate2() + "' ";
        }
        //下单日期起始
        if (StringUtil.isNotEmpty(searchDto.getOrderDateStart())) {
            sql = sql + " AND DATE_FORMAT(a.orderDate,'%Y-%m-%d') >= '" + searchDto.getOrderDateStart() + "' ";
        }
        //下单日期结束
        if (StringUtil.isNotEmpty(searchDto.getOrderDateEnd())) {
            sql = sql + " AND DATE_FORMAT(a.orderDate,'%Y-%m-%d') <= '" + searchDto.getOrderDateEnd() + "' ";
        }
        //活动创建时间
        if (StringUtil.isNotEmpty(searchDto.getCreateDateStart())) {
            sql = sql + " AND DATE_FORMAT(a.createOn,'%Y-%m-%d') >= '" + searchDto.getCreateDateStart() + "' ";
        }
        //活动创建时间
        if (StringUtil.isNotEmpty(searchDto.getCreateDateEnd())) {
            sql = sql + " AND DATE_FORMAT(a.createOn,'%Y-%m-%d') <= '" + searchDto.getCreateDateEnd() + "' ";
        }
        //活动类型
        if (StringUtil.isNotEmpty(searchDto.getActivityType())) {
            sql = sql + " AND a.activityType = '" + searchDto.getActivityType() + "' ";
        }

        //活动状态
        if (StringUtil.isNotEmpty(searchDto.getActivityStatus())) {
            sql = sql + " AND a.activityStatus = '" + searchDto.getActivityStatus() + "' ";
        }

        //是否需要风评
        if (StringUtil.isNotEmpty(searchDto.getIsAssessment())) {
            sql = sql + " AND a.needReport = '" + searchDto.getIsAssessment() + "' ";
        }

        //关键词搜索范围：承办单位名称、活动名称、举办地址，并支持模糊搜索
        if (StringUtil.isNotEmpty(searchDto.getKeyWord())) {
            sql = sql + " AND ( a.sponsor like '%" + searchDto.getKeyWord() + "%' " +
                    "OR  a.`name` LIKE '%" + searchDto.getKeyWord() + "%' OR a.address LIKE '%" + searchDto.getKeyWord() + "%')";
        }
        //活动城市
        if (StringUtil.isNotEmpty(searchDto.getProvinceId())) {
            sql = sql + " AND a.province_id = '" + searchDto.getProvinceId() + "' ";
        }
        //活动城市
        if (StringUtil.isNotEmpty(searchDto.getCityId())) {
            sql = sql + " AND a.city_id = '" + searchDto.getCityId() + "' ";
        }
        //活动城市
        if (StringUtil.isNotEmpty(searchDto.getAreaId())) {
            sql = sql + " AND a.area_id = '" + searchDto.getAreaId() + "' ";
        }
        //许可单位
        if (StringUtil.isNotEmpty(searchDto.getApprovalUnit())) {
            sql = sql + " AND a.approveOrg like '%" + searchDto.getApprovalUnit() + "%' ";
        }
        if (page != null) {
            page.setTotalCount(querySqlCounts(sql, wrapper));
            sql += getOrderTypeSql(searchDto.getSortValue());
            sql = sql + " limit " + (page.getPageNum() - 1) * page.getNumPerPage() + "," + page.getNumPerPage();
        }
        return queryMaps(sql, wrapper);
    }


    /**
     * 根据枚举类型组装排序sql
     *
     * @param order
     * @return
     * @Author 张建华
     */
    private String getOrderTypeSql(String order) {

        if ((OrderTypeEnum.ORDER_DESC.getKey()).equals(order)) {
            return " ORDER BY a.orderDate DESC ";

        } else if ((OrderTypeEnum.ORDER_ASC.getKey()).equals(order)) {
            return " ORDER BY a.orderDate ASC ";

        } else if ((OrderTypeEnum.DATE_FROM_ASC.getKey()).equals(order)) {
            return " ORDER BY  timeStampDiff(DAY, NOW(), a.startDate) <=0,timeStampDiff(DAY, NOW(), a.startDate) asc ";

        } else if ((OrderTypeEnum.DATE_FROM_DESC.getKey()).equals(order)) {
            return " ORDER BY timeStampDiff(DAY, NOW(), a.startDate) desc ";

        } else if ((OrderTypeEnum.ACTIVITY_START_DATE_ASC.getKey()).equals(order)) {
            return " ORDER BY a.startDate ASC ";

        } else if ((OrderTypeEnum.ACTIVITY_START_DATE_DESC.getKey()).equals(order)) {
            return " ORDER BY a.startDate DESC ";

        } else if ((OrderTypeEnum.ACTIVITY_END_DATE_ASC.getKey()).equals(order)) {
            return " ORDER BY a.endDate ASC ";

        } else if ((OrderTypeEnum.ACTIVITY_END_DATE_DESC.getKey()).equals(order)) {
            return " ORDER BY a.endDate DESC ";

        } else if ((OrderTypeEnum.ORDER_AMOUNT_DESC.getKey()).equals(order)) {
            return " ORDER BY o.amount DESC ";

        } else if ((OrderTypeEnum.ORDER_AMOUNT_ASC.getKey()).equals(order)) {
            return " ORDER BY o.amount ASC ";

        } else if ((OrderTypeEnum.CREATE_DESC.getKey()).equals(order)) {
            return " ORDER BY a.createOn DESC ";

        } else if ((OrderTypeEnum.CREATE_ASC.getKey()).equals(order)) {
            return " ORDER BY a.createOn ASC ";

        } else {
            return " ORDER BY a.oid DESC ";
        }
    }


    @Override
    public List<OrderFormDataDTO> findServiceOrderListByOrderStatus(OrderFormSearchDTO searchDto, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select t.paymentMode,o.refundAmount,o.oid as orderId," +
                " a.oid as activityId," +
                " a.name as activityName," +
                " a.activitySource," +
                " so.serviceOrgType," +
                " o.orderNo,DATE_FORMAT(a.orderDate,'%Y-%m-%d %H:%i:%s') AS orderDate,a.activityType,o.orderStatus," +
                " a.activityStatus,o.reportAmount as reportAmount,o.discountAmount as discountAmount,o.amount as total,ac.amount ,a.gov,IFNULL(a.chooseAssess,'1') AS chooseAssess " +
                " from " + TableConst.ACTIVITY_TABLE + " a " +
                " inner join " + TableConst.ORDERFORM_TABLE + " o on o.activity_id = a.oid " +
                " inner join " + TableConst.ACTIVITYCOOPER_TABLE + " ac on ac.activity_id = a.oid " +
                " inner join " + TableConst.SERIVICEORG_TABLE + " so on so.oid = ac.org_id " +
                " left join risk_transaction t on t.orderForm_id  = o.oid ";

        wrapper.notIn("o.orderStatus", Lists.newArrayList(DictConst.ORDERSTATUS_YSC));
        wrapper.notIn("a.activitySource", Lists.newArrayList(DictConst.ACTIVITYSOURCE_XTLR));
        if (searchDto.getOrg() != null) {
            wrapper.eq("ac.org_id", searchDto.getOrg().getOid());
        }
        if (StringUtil.isNotEmpty(searchDto.getKeyname())) {
            wrapper.like("a.name", searchDto.getKeyname());
        }
        if (StringUtil.isNotEmpty(searchDto.getProcess())) {
            wrapper.eq("o.orderStatus", searchDto.getProcess());
        }
        if (StringUtil.isNotEmpty(searchDto.getOrderStatus())) {
            wrapper.eq("o.orderStatus", searchDto.getOrderStatus());
        }
        if (StringUtil.isNotEmpty(searchDto.getActivitySource())) {
            wrapper.eq("a.activitySource", searchDto.getActivitySource());
        }
        wrapper.orderBy("a.oid", false);
        List<OrderFormDataDTO> dtoList = Lists.newArrayList();
        Page<Map<String, Object>> pageList = queryMapsPage(sql, wrapper, page);
        List<Map<String, Object>> list = pageList.getRecords();
        list.forEach(result -> {
            OrderFormDataDTO dto = new OrderFormDataDTO(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }

    @Override
    public List findExportActivityList(OrderFormSearchDTO searchDto, DwzPage page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        StringBuffer sql = new StringBuffer("select DISTINCT ");
        sql.append("ra.createOn,");
        sql.append("ra.orderDate,");
        sql.append("rof.orderNo,");
        sql.append("ra.`name` as 'activityName',");
        sql.append("dict7.label as 'activitySource',");
        sql.append("dict6.label as 'activityType',");
        sql.append("sd5.label as 'activityStatus',");
        sql.append("CONCAT(sr1.province,IFNULL(sr2.city,''),IFNULL(sr3.area,'')) as 'place',");
        sql.append("ra.address,");
        sql.append("ra.sbApprovalStatus,");
        sql.append("if(ra.isBackup=1,'否','是') as isBackup,");
        sql.append("ra.sponsor,");
        sql.append("ra.startDate,");
        sql.append("ra.endDate,");
        sql.append("if(timeStampDiff(DAY, NOW(), ra.startDate)>0,timeStampDiff(DAY, NOW(), ra.startDate),'') AS dateFrom,");
        sql.append("rsu.realName,");
        sql.append("rsu.phone,");
        sql.append("rt.endTime,");
        sql.append("rof.amount,");
        sql.append("rof.reportAmount,");
        sql.append("rof.discountAmount,");
        sql.append("if( rt.paymentMode='2','线下支付',sd4.label) as 'paymentMode',");
        sql.append("sd1.label as 'orderStatus',");
        sql.append("rof.contractAmount,");
        sql.append("rof.monitorAmount,");
        sql.append("sd2.label as 'reportExpressMode',");
        sql.append("sd3.label as 'invoiceExpressMode',");
        sql.append("org.`name` as 'riskCompany',");
        sql.append("IF(ri.oid is null,'未在平台购买保障','已投保') as 'insurancePolicy'");
        sql.append("from risk_activity ra");
        sql.append(" INNER JOIN SYS_DICT dict6 on dict6.type='ACTIVITYTYPE' and dict6.`value`=ra.activityType");
        sql.append(" INNER JOIN SYS_DICT dict7 on dict7.type='ACTIVITYSOURCE' and dict7.`value`=ra.activitySource");
        sql.append(" INNER JOIN RISK_OrderForm rof on ra.oid=rof.activity_id");
        sql.append(" LEFT JOIN RISK_Transaction rt on rt.orderForm_id = rof.oid and rt.payStatus='1'");
        sql.append(" INNER JOIN risk_report rr on rr.activity_id=ra.oid");
        sql.append(" LEFT JOIN RISK_ActivityExpress rae on rae.orderForm_id= rof.oid");
        sql.append(" LEFT JOIN (select ro.oid,ro.`name`,rac.activity_id from RISK_Activity_Cooper rac");
        sql.append(" INNER JOIN risk_serviceorg rs on rac.org_id=rs.oid and rs.serviceOrgType='1'");
        sql.append(" INNER JOIN risk_org ro on ro.oid=rs.oid  ");
        sql.append(" ) org on org.activity_id = ra.oid");
        sql.append(" LEFT JOIN (select ro.oid,ro.`name`,rac.activity_id from RISK_Activity_Cooper rac");
        sql.append(" INNER JOIN risk_serviceorg rs on rac.org_id=rs.oid and rs.serviceOrgType='5'");
        sql.append(" INNER JOIN risk_org ro on ro.oid=rs.oid  ");
        sql.append(" ) org1 on org1.activity_id = ra.oid");
        sql.append(" LEFT JOIN RISK_InsurancePolicy ri on ri.activity_id=ra.oid");
        sql.append(" INNER JOIN risk_se_user rsu on rsu.oid= ra.user_id");
        sql.append(" INNER JOIN sys_region sr1 on sr1.oid=ra.province_id");
        sql.append(" LEFT JOIN sys_region sr2 on sr2.oid=ra.city_id");
        sql.append(" LEFT JOIN sys_region sr3 on sr3.oid=ra.area_id");
        sql.append(" LEFT JOIN sys_dict sd1 on sd1.type='ORDERSTATUS' and sd1.`value`=rof.orderStatus");
        sql.append(" LEFT JOIN sys_dict sd2 on sd2.type='REPORTEXPRESS' and sd2.`value`=rae.reportExpressMode");
        sql.append(" LEFT JOIN sys_dict sd3 on sd3.type='INVOICEEXPRESS' and sd3.`value`=rae.invoiceExpressMode");
        sql.append(" LEFT JOIN sys_dict sd4 on sd4.type='PAYMENTTYPE' and sd4.`value`=rt.paymentType");
        sql.append(" INNER JOIN sys_dict sd5 on sd5.type='ACTIVITYSTATUS' and sd5.`value`=ra.activityStatus");
        sql.append(" where rof.orderStatus != '" + DictConst.ORDERSTATUS_YSC + "' ");

        if (StringUtil.isEmpty(searchDto.getExportType())) {
            return null;
        } else {
            /* 活动列表 */
            if ("1".equals(searchDto.getExportType())) {
                /* 无需加任何条件，默认查询所有 */
            }
            /* 订单列表 */
            else if ("2".equals(searchDto.getExportType())) {
                sql.append(" AND ra.activitySource != '" + DictConst.ACTIVITYSOURCE_XTLR + "'");
            }
            /* 许可列表 */
            else if ("3".equals(searchDto.getExportType())) {
                sql.append(" and ra.isBackup = '" + DictConst.N + "' and ra.activitySource != '" + DictConst.ACTIVITYSOURCE_XTLR + "'");
            }
            /* 政府列表 */
            else if ("4".equals(searchDto.getExportType())) {
                sql.append(" and ra.gov = '" + DictConst.Y + "' AND ra.isBackup = '" + DictConst.Y + "' and ra.activitySource != '" + DictConst.ACTIVITYSOURCE_XTLR + "'");
            }
        }
        if (StringUtil.isNotEmpty(searchDto.getStartDate())) {
            sql.append(" AND DATE_FORMAT(ra.startDate,'%Y-%m-%d') >= '" + searchDto.getStartDate() + "' ");
        }
        if (StringUtil.isNotEmpty(searchDto.getEndDate())) {
            sql.append(" AND DATE_FORMAT(ra.startDate,'%Y-%m-%d') <= '" + searchDto.getEndDate() + "' ");
        }

        //活动结束时间起始
        if (StringUtil.isNotEmpty(searchDto.getEndDate1())) {
            sql.append(" AND DATE_FORMAT(ra.endDate,'%Y-%m-%d') >= '" + searchDto.getEndDate1() + "' ");
        }
        //活动结束时间终止
        if (StringUtil.isNotEmpty(searchDto.getEndDate2())) {
            sql.append(" AND DATE_FORMAT(ra.endDate,'%Y-%m-%d') <= '" + searchDto.getEndDate2() + "' ");
        }
        //下单日期起始
        if (StringUtil.isNotEmpty(searchDto.getOrderDateStart())) {
            sql.append("  AND DATE_FORMAT(ra.orderDate,'%Y-%m-%d') >= '" + searchDto.getOrderDateStart() + "' ");
        }
        //下单日期结束
        if (StringUtil.isNotEmpty(searchDto.getOrderDateEnd())) {
            sql.append("  AND DATE_FORMAT(ra.orderDate,'%Y-%m-%d') <= '" + searchDto.getOrderDateEnd() + "' ");
        }
        //活动创建时间
        if (StringUtil.isNotEmpty(searchDto.getCreateDateStart())) {
            sql.append(" AND DATE_FORMAT(ra.createOn,'%Y-%m-%d') >= '" + searchDto.getCreateDateStart() + "' ");
        }
        //活动创建时间
        if (StringUtil.isNotEmpty(searchDto.getCreateDateEnd())) {
            sql.append("  AND DATE_FORMAT(ra.createOn,'%Y-%m-%d') <= '" + searchDto.getCreateDateEnd() + "' ");
        }
        //活动来源
        if (StringUtil.isNotEmpty(searchDto.getActivitySource())) {
            sql.append("  AND ra.activitySource = '" + searchDto.getActivitySource() + "' ");
        }
        //活动类型
        if (StringUtil.isNotEmpty(searchDto.getActivityType())) {
            sql.append("  AND ra.activityType = '" + searchDto.getActivityType() + "' ");
        }

        //活动状态
        if (StringUtil.isNotEmpty(searchDto.getActivityStatus())) {
            sql.append("  AND ra.activityStatus = '" + searchDto.getActivityStatus() + "' ");

        }
        //审批状态
        if (StringUtil.isNotEmpty(searchDto.getSbApprovalStatus())) {
            sql.append("  AND ra.sbApprovalStatus = '" + searchDto.getSbApprovalStatus() + "' ");

        }
        //订单状态
        if (StringUtil.isNotEmpty(searchDto.getOrderStatus())) {
            sql.append("  AND  rof.orderStatus = '" + searchDto.getOrderStatus() + "' ");
        }
        //支付方式
        if (StringUtil.isNotEmpty(searchDto.getPayMethod())) {
            sql.append("  AND rt.paymentMode  = '" + searchDto.getPayMethod() + "' ");

        }

        //关键词搜索范围：承办单位名称、活动名称、举办地址，并支持模糊搜索
        if (StringUtil.isNotEmpty(searchDto.getKeyWord())) {
            sql.append(" AND ( ra.sponsor like '%" + searchDto.getKeyWord() + "%' " +
                    "OR  ra.`name` LIKE '%" + searchDto.getKeyWord() + "%' OR ra.address LIKE '%" + searchDto.getKeyWord() + "%')");
        }
        //活动城市
        if (StringUtil.isNotEmpty(searchDto.getProvinceId())) {
            sql.append("  AND ra.province_id = '" + searchDto.getProvinceId() + "' ");
        }
        //活动城市
        if (StringUtil.isNotEmpty(searchDto.getCityId())) {
            sql.append(" AND ra.city_id = '" + searchDto.getCityId() + "' ");
        }
        //活动城市
        if (StringUtil.isNotEmpty(searchDto.getAreaId())) {
            sql.append(" AND ra.area_id = '" + searchDto.getAreaId() + "' ");
        }

        sql.append(getExportOrderTypeSql(searchDto.getSortValue()));

        System.out.println(sql.toString());

        return queryMaps(sql.toString(), wrapper);
    }

    /**
     * 根据枚举类型组装排序sql
     *
     * @param order
     * @return
     */
    private String getExportOrderTypeSql(String order) {
        if (Objects.equals(order, OrderTypeEnum.ORDER_DESC.getKey())) {
            return " ORDER BY ra.orderDate DESC ";
        } else if (Objects.equals(order, OrderTypeEnum.ORDER_ASC.getKey())) {
            return " ORDER BY ra.orderDate ASC ";
        } else if (Objects.equals(order, OrderTypeEnum.ORDER_AMOUNT_DESC.getKey())) {
            return " ORDER BY rof.amount DESC ";
        } else if (Objects.equals(order, OrderTypeEnum.ORDER_AMOUNT_ASC.getKey())) {
            return " ORDER BY rof.amount ASC ";
        } else if (Objects.equals(order, OrderTypeEnum.DATE_FROM_DESC.getKey())) {
            return "  ORDER BY  timeStampDiff(DAY, NOW(), ra.startDate) <=0,timeStampDiff(DAY, NOW(), ra.startDate) DESC ";
        } else if (Objects.equals(order, OrderTypeEnum.DATE_FROM_ASC.getKey())) {
            return "  ORDER BY  timeStampDiff(DAY, NOW(), ra.startDate) <=0,timeStampDiff(DAY, NOW(), ra.startDate) ASC ";
        } else if (Objects.equals(order, OrderTypeEnum.ACTIVITY_START_DATE_DESC.getKey())) {
            return " ORDER BY ra.startDate DESC ";
        } else if (Objects.equals(order, OrderTypeEnum.ACTIVITY_START_DATE_ASC.getKey())) {
            return " ORDER BY ra.startDate ASC ";
        } else if (Objects.equals(order, OrderTypeEnum.ACTIVITY_END_DATE_DESC.getKey())) {
            return " ORDER BY ra.endDate DESC ";
        } else if (Objects.equals(order, OrderTypeEnum.ACTIVITY_END_DATE_ASC.getKey())) {
            return " ORDER BY ra.endDate ASC ";
        } else if (Objects.equals(order, OrderTypeEnum.CREATE_DESC.getKey())) {
            return " ORDER BY ra.createOn DESC ";
        } else if (Objects.equals(order, OrderTypeEnum.CREATE_ASC.getKey())) {
            return " ORDER BY ra.createOn ASC ";
        } else {
            return " ORDER BY ra.oid DESC";
        }
    }


    /**
     * 根据活动获取订单信息
     *
     * @param activity
     * @return
     */
    @Override
    public OrderForm findOrderFormByActivity(Activity activity) {
        List<Criterion> criterionList = new ArrayList<Criterion>();
        criterionList.add(Restrictions.eq("activity", activity));
        List<OrderForm> orders = this.selectList(criterionList);
        if (orders != null && orders.size() > 0) {
            return orders.get(0);
        }
        return null;
    }

    @Override
    public int countOrder() {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select a.oid " +
                "                 from RISK_ACTIVITY a   " +
                "                 inner join RISK_ORDERFORM o on o.activity_id = a.oid  " +
                "                 inner join sys_region p on p.oid = a.province_id " +
                "                 inner join RISK_SE_USER u on o.user_id = u.oid  " +
                "                 inner JOIN sys_region sr1 ON sr1.oid = a.city_id  " +
                "                 LEFT JOIN sys_region sr2 ON sr2.oid = a.area_id  " +
                "                 INNER JOIN sys_dict sd on sd.`value`= a.activityStatus and sd.type='activityStatus' " +
                "                 LEFT JOIN risk_transaction b on b.orderNo = o.orderNo and b.payStatus='1' " +
                "                 where 1=1 and o.orderStatus != '9'  " +
                "                 and ((a.gov =1 and a.isBackup ='0') or (a.gov ='' or ISNULL(a.gov) or a.gov ='0')) ;";
        List list = queryMaps(sql, wrapper);
        if (CollectionUtil.isNotEmpty(list)) {
            return list.size();
        }
        return 0;
    }


    @Override
    public int countActivity() {
        SelectWrapper wrapper = SelectWrapper.instance();
        StringBuffer sql = new StringBuffer("SELECT\n" +
                "       a.oid\n" +
                "    FROM\n" +
                "        RISK_ACTIVITY a  \n" +
                "    INNER JOIN\n" +
                "        risk_orderForm o \n" +
                "            ON a.oid = o.activity_id  \n" +
                "    INNER JOIN\n" +
                "        sys_region p \n" +
                "            ON p.oid = a.province_id  \n" +
                "    LEFT JOIN\n" +
                "        sys_region sr1 \n" +
                "            ON sr1.oid = a.city_id  \n" +
                "    LEFT JOIN\n" +
                "        sys_region sr2 \n" +
                "            ON sr2.oid = a.area_id  \n" +
                "    INNER JOIN\n" +
                "        sys_dict sd \n" +
                "            on sd.`value`= a.activityStatus \n" +
                "            and sd.type='activityStatus' \n" +
                "            AND (\n" +
                "                a.gov ='' \n" +
                "                or ISNULL(a.gov) \n" +
                "                or a.gov ='0'\n" +
                "            )  \n" +
                "            AND o.orderStatus NOT IN (\n" +
                "                '9'\n" +
                "            ) \n" +
                "    ORDER BY\n" +
                "        a.oid DESC  ");
        List list = queryMaps(sql.toString(), wrapper);
        if (CollectionUtil.isNotEmpty(list)) {
            return list.size();
        }
        return 0;
    }

    @Override
    public int countGovActivity() {
        SelectWrapper wrapper = SelectWrapper.instance();
        StringBuffer sql = new StringBuffer("SELECT\n" +
                "       a.oid\n" +
                "    FROM\n" +
                "        RISK_ACTIVITY a  \n" +
                "    INNER JOIN\n" +
                "        sys_region p \n" +
                "            ON p.oid = a.province_id  \n" +
                "    LEFT JOIN\n" +
                "        sys_region sr1 \n" +
                "            ON sr1.oid = a.city_id  \n" +
                "    LEFT JOIN\n" +
                "        sys_region sr2 \n" +
                "            ON sr2.oid = a.area_id  \n" +
                "    INNER JOIN\n" +
                "        sys_dict sd \n" +
                "            on sd.`value`= a.activityStatus \n" +
                "            and sd.type='activityStatus' \n" +
                "    where\n" +
                "        a.gov = '1'  \n" +
                "        AND a.activityStatus NOT IN (\n" +
                "            '9'\n" +
                "        )  \n" +
                "    ORDER BY\n" +
                "        a.oid DESC  ");
        List list = queryMaps(sql.toString(), wrapper);
        if (CollectionUtil.isNotEmpty(list)) {
            return list.size();
        }
        return 0;
    }

    @Override
    public List newOrderFormList() {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT " +
                "  p.province, " +
                "  sr1.city, " +
                "  sr2.area, " +
                "  a. NAME AS activityName, " +
                "  DATE_FORMAT( " +
                " a.createOn, " +
                " '%Y-%m-%d %H:%i:%s' " +
                "  ) AS createOn, " +
                "  a.sponsor " +
                "FROM " +
                "  RISK_ACTIVITY a " +
                "INNER JOIN sys_region p ON p.oid = a.province_id " +
                "INNER JOIN RISK_ORDERFORM o ON o.activity_id = a.oid " +
                "INNER JOIN RISK_SE_USER u ON o.user_id = u.oid " +
                "LEFT JOIN sys_region sr1 ON sr1.oid = a.city_id " +
                "LEFT JOIN sys_region sr2 ON sr2.oid = a.area_id " +
                "INNER JOIN sys_dict sd ON sd.`value` = a.activityStatus " +
                "AND sd.type = 'activityStatus' " +
                "LEFT JOIN risk_transaction b ON b.orderNo = o.orderNo " +
                "AND b.payStatus = '1' " +
                "WHERE " +
                "  1 = 1 " +
                "AND o.orderStatus NOT IN ('9') " +
                "AND ( " +
                "  (a.gov = 1 AND a.isBackup = '0') " +
                "  OR ( " +
                " a.gov = '' " +
                " OR ISNULL(a.gov) " +
                " OR a.gov = '0' " +
                "  ) " +
                ") " +
                "ORDER BY " +
                "  a.createOn DESC " +
                "LIMIT 5 ";
        return queryMaps(sql, wrapper);
    }

    @Override
    public List newGovActivity() {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT " +
                "  p.province, " +
                "  sr1.city, " +
                "  sr2.area, " +
                "  a. NAME AS activityName, " +
                "  DATE_FORMAT( " +
                " a.createOn, " +
                " '%Y-%m-%d %H:%i:%s' " +
                "  ) AS createOn, " +
                "  a.sponsor " +
                "FROM " +
                "  RISK_ACTIVITY a " +
                "INNER JOIN sys_region p ON p.oid = a.province_id " +
                "INNER JOIN RISK_ORDERFORM o ON o.activity_id = a.oid " +
                "INNER JOIN RISK_SE_USER u ON o.user_id = u.oid " +
                "LEFT JOIN sys_region sr1 ON sr1.oid = a.city_id " +
                "LEFT JOIN sys_region sr2 ON sr2.oid = a.area_id " +
                "INNER JOIN sys_dict sd ON sd.`value` = a.activityStatus " +
                "AND sd.type = 'activityStatus' " +
                "LEFT JOIN risk_transaction b ON b.orderNo = o.orderNo " +
                "AND b.payStatus = '1' " +
                "WHERE " +
                "  1 = 1 " +
                "AND o.orderStatus NOT IN ('9') " +
                "AND a.gov= '1'" +
                "ORDER BY " +
                "  a.createOn DESC " +
                "LIMIT 5 ";
        return queryMaps(sql, wrapper);
    }

    @Override
    public List newActivity() {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT " +
                "  p.province, " +
                "  sr1.city, " +
                "  sr2.area, " +
                "  a. NAME AS activityName, " +
                "  DATE_FORMAT( " +
                " a.createOn, " +
                " '%Y-%m-%d %H:%i:%s' " +
                "  ) AS createOn, " +
                "  a.sponsor " +
                "FROM " +
                "  RISK_ACTIVITY a " +
                "INNER JOIN sys_region p ON p.oid = a.province_id " +
                "INNER JOIN RISK_ORDERFORM o ON o.activity_id = a.oid " +
                "INNER JOIN RISK_SE_USER u ON o.user_id = u.oid " +
                "LEFT JOIN sys_region sr1 ON sr1.oid = a.city_id " +
                "LEFT JOIN sys_region sr2 ON sr2.oid = a.area_id " +
                "INNER JOIN sys_dict sd ON sd.`value` = a.activityStatus " +
                "AND sd.type = 'activityStatus' " +
                "LEFT JOIN risk_transaction b ON b.orderNo = o.orderNo " +
                "AND b.payStatus = '1' " +
                "WHERE " +
                "  1 = 1 " +
                "AND o.orderStatus NOT IN ('9') " +
                " AND (a.gov ='' or ISNULL(a.gov) or a.gov ='0') " +
                "ORDER BY " +
                "  a.createOn DESC " +
                "LIMIT 5 ";
        return queryMaps(sql, wrapper);
    }
}
