package com.bcxin.risk.news;

import com.bcxin.risk.base.dao.BaseDao;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.news.domain.News;
import com.bcxin.risk.news.dto.search.NewsSearchDTO;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Repository("newsDao")
public class NewsDaoImpl extends DaoImpl<News> implements NewsDao {

	@Resource
	private BaseDao baseDao;


	@Override
	public List<News> findNewsList(NewsSearchDTO searchDTO, DwzPage page) {
		List<Criterion> criterionList = Lists.newArrayList();
		if(StringUtil.isNotEmpty(searchDTO.getNewsType())){
			criterionList.add(Restrictions.eq("newsType",searchDTO.getNewsType()));
		}
		if(StringUtil.isNotEmpty(searchDTO.getProvinceId())){
			criterionList.add(Restrictions.eq("provinceId",searchDTO.getProvinceId()));
		}
		if(StringUtil.isNotEmpty(searchDTO.getTitle())){
			criterionList.add(Restrictions.like("title","%"+ searchDTO.getTitle() +"%"));
		}
		List<Order> orderList = new ArrayList<Order>();
		orderList.add(Order.desc("createOn"));
		if ( page == null ) {
			return baseDao.findByCriterion(News.class, criterionList,orderList);
		}
		return baseDao.findByCriterionForPage(News.class, criterionList, page,orderList);
	}

	@Override
	public List<News> findProvinceNewsList(String provinceId) {
		List<Criterion> criterionList = Lists.newArrayList();
		criterionList.add(Restrictions.or(Restrictions.eq("provinceId",provinceId),
				Restrictions.eq("provinceId", DictConst.REGION_CHINA)));
		return baseDao.findByCriterion(News.class, criterionList);
	}

}
