package com.bcxin.risk.log;

import cn.hutool.core.date.DateUtil;
import com.bcxin.risk.base.dao.BaseDao;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.log.dto.search.UserOpSearchDTO;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import javax.annotation.Resource;
import java.util.List;


@Repository("userOpLogDao")
@SuppressWarnings("unchecked")
public class UserOpLogDaoImpl extends DaoImpl<UserOpLog> implements UserOpLogDao {

    @Resource
    private BaseDao baseDao;

    @Override
    public List<UserOpLog> queryUserOpLog(UserOpSearchDTO searchDTO, DwzPage page) {
        List<Criterion> criterionList = Lists.newArrayList();
        if(StringUtil.isNotEmpty(searchDTO.getKey())){
            criterionList.add(Restrictions.or(Restrictions.like("action","%"+searchDTO.getKey()+"%")
            ,Restrictions.like("ipAddress","%"+searchDTO.getKey()+"%")
            ,Restrictions.like("menu","%"+searchDTO.getKey()+"%")
            ,Restrictions.like("targetObj","%"+searchDTO.getKey()+"%")));
        }

        if (searchDTO.getUser() != null){
            criterionList.add(Restrictions.eq("user",searchDTO.getUser()));
        }

        if (StringUtil.isNotEmpty(searchDTO.getStartTime()) && StringUtil.isNotEmpty(searchDTO.getEndTime())) {
            criterionList.add(Restrictions.between("createOn",DateUtil.parseDate(searchDTO.getStartTime()),DateUtil.endOfDay(DateUtil.parseDate(searchDTO.getEndTime()))));
        }
        List<Order> orderList = Lists.newArrayList();
        orderList.add(Order.desc("createOn"));
        if ( page == null ) {
            return baseDao.findByCriterion(UserOpLog.class, criterionList,orderList);
        }
        return baseDao.findByCriterionForPage(UserOpLog.class, criterionList, page,orderList);
    }

}