package com.bcxin.risk.log;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.log.dto.search.SMSLogSearchDTO;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public class SMSLogDaoImpl extends DaoImpl<SMSLog> implements SMSLogDao {

    @Override
    public SMSLog findSMSLogByOid(Long oid){
        return selectById(oid);
    }

    @Override
    public List findSMSLogList(SMSLogSearchDTO searchDto, DwzPage page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT " +
                " phone," +
                " content," +
                " success," +
                " DATE_FORMAT(createOn ,'%Y-%m-%d %H:%i:%s' ) as createOn " +
                " FROM log_SMSLog " +
                " where 1=1" ;

        if (StringUtil.isNotEmpty(searchDto.getPhone())) {
            sql = sql+ " AND phone = '"+searchDto.getPhone()+"' ";
        }
        if (StringUtil.isNotEmpty(searchDto.getContent())) {
            sql = sql+ " AND content like '%"+searchDto.getContent()+"%' ";
        }
        if (searchDto.getStartTime() != null && searchDto.getEndTime() != null) {
            sql = sql+ " AND createOn >= '"+searchDto.getStartTime()+"' and createOn <= '"+searchDto.getEndTime()+"'";
        }
        if (page != null) {
            page.setTotalCount(querySqlCounts(sql, wrapper));
            sql = sql + " ORDER BY oid DESC limit " + (page.getPageNum() - 1) * page.getNumPerPage() + "," + page.getNumPerPage();
        }
        return queryMaps(sql, wrapper);
    }

}
