package com.bcxin.risk.log;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.enums.OperateLogTypeEnum;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.log.dto.search.OperateLogDto;
import com.bcxin.risk.log.dto.search.OperateLogSearchDTO;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * Created by PVer on 2017/4/24.
 */
@Repository("operateLogDao")
public class OperateLogDaoImpl extends DaoImpl<OperateLog> implements OperateLogDao {

    /**
     * 重写是否当前事务，将OperateLogDao独立事务出来
     * @return
     */
//    @Override
////    protected Boolean isCurrent() {
////        return Boolean.valueOf(false);
////    }

    @Override
    public OperateLog findOperateLogByOid(Long oid){
        return selectById(oid);
    }

    @Override
    public List<OperateLogDto> findOperateLogList(OperateLogSearchDTO searchDto, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select " +
                "A.oid," +
                "A.userId," +
                "A.operateType," +
                "DATE_FORMAT(A.operateTime,'%Y-%m-%d %H:%i:%s') as operateTime," +
                "A.bizId," +
                "A.sourceId," +
                "A.success," +
                "A.content," +
                "A.ip," +
                "A.expand1," +
                "A.expand2," +
                "A.activityId," +
                "A.activityName, " +
                "B.userName,"+
                "B.realName "+
                "from risk_operate_log A,risk_se_user B where 1=1 and A.userId=B.oid ";

        // 如果是非自营财务权限，限制查询条件
        if(!searchDto.getIsSelfFinance()){
            String filerType=OperateLogTypeEnum.LOGIN_IN.getKey()+","
                    +OperateLogTypeEnum.PAY_DELAY.getKey()+","
                    +OperateLogTypeEnum.CHECK_RECEIPT.getKey();
            sql = sql + " and A.operateType in ("+filerType +") ";
        }

        if(searchDto.getUserIdList() !=null && searchDto.getUserIdList().size()>0){
            String ids="";
            for(Long id : searchDto.getUserIdList()){
                ids+=id+",";
            }
            if(StringUtil.isNotEmpty(ids)){
                ids=ids.substring(0,ids.length()-1);
            }
            sql+=" and A.userId in ( "+ ids +" )";
        }
        if (StringUtil.isNotEmpty(searchDto.getOperateType())) {
            sql = sql + " and A.operateType = '"+searchDto.getOperateType()+"'";
        }
        if(StringUtil.isNotEmpty(searchDto.getSuccess())){
            sql = sql + " and A.success = '"+searchDto.getSuccess()+"'";
        }
        if (StringUtil.isNotEmpty(searchDto.getKeyword())) {
            sql = sql + " and (A.activityName like '%"+searchDto.getKeyword()+"%' or A.ip like '%"+searchDto.getKeyword()+"%' or B.realName like '%"+searchDto.getKeyword()+"%' or A.activityName like '%"+searchDto.getKeyword()+"%')";
        }

        sql = sql + " order by A.operateTime desc";
        List<OperateLogDto> dtoList = Lists.newArrayList();
        Page<Map<String, Object>> pageList = queryMapsPage(sql, wrapper, page);
        List<Map<String, Object>> list = pageList.getRecords();
        list.forEach(result -> {
            OperateLogDto dto = new OperateLogDto(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }
}
