package com.bcxin.risk.expert;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.expert.domain.ExpertCheckInfo;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.user.dto.data.ExpertCheckInfoDto;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * @author hzp
 * 专家待审核资料DAO实现层
 */
@Repository("expertCheckInfoDao")
public class ExpertCheckInfoDaoImpl extends DaoImpl<ExpertCheckInfo> implements ExpertCheckInfoDao {

    /**
     * 根据主键ID获取专家待审核资料实体
     * @param oid 主键ID
     * @return
     */
    @Override
    public ExpertCheckInfo findByOid(Long oid) {
        return selectById(oid);
    }

    /**
     * 根据用户ID获取专家待审核资料实体
     * @param userId 专家用户ID
     * @return
     */
    @Override
    public ExpertCheckInfo findByUserId(Long userId) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("userId",userId);
        return selectOne(wrapper);
    }

    /**
     * 根据状态查询专家资料信息列表
     * @param checkStatus 审核状态
     * @return 资料列表
     */
    @Override
    public List<ExpertCheckInfo> findCheckList(String checkStatus){
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("checkStatus",checkStatus);
        return selectList(wrapper);
    }

    /**
     * 分页查询
     * @param expertCheckInfoDto
     * @param page
     * @return
     */
    @Override
    public List<Map<String, Object>> reviewExpertList(ExpertCheckInfoDto expertCheckInfoDto, DwzPage page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = " SELECT a.*,b.`name` as company,c.userName as account,c.userType as userType from risk_expertcheckinfo a INNER JOIN risk_org b " +
                " ON a.orgId = b.oid INNER JOIN risk_se_user c ON a.userId = c.oid  WHERE 1=1 ";
        if (expertCheckInfoDto != null) {

            if (StringUtil.isNotEmpty(expertCheckInfoDto.getAccount())) {
                sql += " AND c.userName LIKE '%" + expertCheckInfoDto.getAccount() + "%' ";
            }
            if (StringUtil.isNotEmpty(expertCheckInfoDto.getCheckStatus())) {
                sql += " AND a.checkStatus ='" + expertCheckInfoDto.getCheckStatus() + "' ";
            }
            if (StringUtil.isNotEmpty(expertCheckInfoDto.getCompany())) {
                sql += "  AND b.`name` LIKE '%" + expertCheckInfoDto.getCompany() + "%' ";
            }
            if (StringUtil.isNotEmpty(expertCheckInfoDto.getRealName())) {
                sql += " AND a.realName LIKE '%" + expertCheckInfoDto.getRealName() + "%' ";
            }
            if (StringUtil.isNotEmpty(expertCheckInfoDto.getUserType())) {
                sql += " AND c.userType  ='" + expertCheckInfoDto.getUserType() + "' ";
            }
        }
        if (page != null) {
            page.setTotalCount(querySqlCounts(sql, wrapper));
            sql = sql + " ORDER BY a.updateOn DESC limit " + (page.getPageNum() - 1) * page.getNumPerPage() + "," + page.getNumPerPage();
        }
        return queryMaps(sql, wrapper);
    }

    /**
     * 根据主键ID获取专家待审核资料Map对象
     * @param oid 主键ID
     * @return
     */
    @Override
    public List<Map<String, Object>> selectExpertCheckInfoById(Long oid) {

        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = " SELECT a.*,b.`name` as company,c.userName as account,c.userType as userType from risk_expertcheckinfo a INNER JOIN risk_org b " +
                " ON a.orgId = b.oid INNER JOIN risk_se_user c ON a.userId = c.oid  WHERE a.oid = " + oid;
        return queryMaps(sql, wrapper);
    }

    @Override
    public List newReviewExpertList() {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT a.realName,b.`name` as company,c.userName as account,c.userType as userType from risk_expertcheckinfo a  " +
                "INNER JOIN risk_org b  ON a.orgId = b.oid INNER JOIN risk_se_user c ON a.userId = c.oid  WHERE 1=1 AND a.checkStatus = '1' ORDER BY a.updateOn DESC LIMIT 5 ";
        return queryMaps(sql, wrapper);
    }
}
