package com.bcxin.risk.dynamic;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.dynamic.dto.DynamicPanelDto;
import com.bcxin.risk.dynamic.dto.DynamicSearchDto;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * @author hzp
 * 动态看板 Dao实现类
 */
@Repository("dynamicPanelDao")
public class DynamicPanelDaoImpl extends DaoImpl<DynamicPanel> implements DynamicPanelDao {


    @Override
    public List<DynamicPanelDto> searchDynamicPanelList(DynamicSearchDto searchDto, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select " +
                " A.oid," +
                " A.templateId," +
                " A.dynamicType," +
                " A.activityId," +
                " A.activityName," +
                " B.template," +
                " A.templateData," +
                " A.orgId," +
                " A.contractOrgId," +
                " DATE_FORMAT(A.createOn,'%Y-%m-%d %H:%i:%s') as createOn " +
                " from risk_dynamic_panel A " +
                " INNER JOIN risk_dynamic_panel_template B on A.templateId=B.oid " +
                " where 1=1 and A.isShow='" + DictConst.Y + "'";

        if (searchDto.getOrgId() != null) {
            sql += " and A.orgId=" + searchDto.getOrgId();
        }
        if (searchDto.getContractOrgId() != null) {
            sql += " and A.contractOrgId=" + searchDto.getContractOrgId();
        }
        if (StringUtil.isNotEmpty(searchDto.getActivityId())) {
            sql += " and A.activityId=" + searchDto.getActivityId();
        }
        if (StringUtil.isNotEmpty(searchDto.getDynamicType())) {
            sql += " and A.dynamicType=" + searchDto.getDynamicType();

        }
        if (StringUtil.isNotEmpty(searchDto.getActivityName())) {
            sql = sql + " and A.activityName = '" + searchDto.getActivityName() + "'";
        }
        if (StringUtil.isNotEmpty(searchDto.getStartTime())) {
            sql = sql + " and A.createOn >= '" + searchDto.getStartTime() + "'";
        }
        if (StringUtil.isNotEmpty(searchDto.getEndTime())) {
            sql = sql + " and A.createOn <= '" + searchDto.getEndTime() + "'";
        }

        if (StringUtil.isNotEmpty(searchDto.getOrder())) {
            sql = sql + " order by A.createOn " + searchDto.getOrder();
        } else {
            sql = sql + " order by A.createOn desc ";
        }

        List<DynamicPanelDto> dtoList = Lists.newArrayList();
        Page<Map<String, Object>> pageList = queryMapsPage(sql, wrapper, page);
        List<Map<String, Object>> list = pageList.getRecords();
        list.forEach(result -> {
            DynamicPanelDto dto = new DynamicPanelDto(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }

    @Override
    public boolean checkDynamic(Long templateId, Long userId, Long activityId) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select count(1) as total from risk_dynamic_panel t where t.activityId=" + activityId + " and t.templateId=" + templateId + " and t.operateId=" + userId;
        Map<String, Object> map = queryMap(sql, wrapper);
        if (map != null) {
            Integer num = Integer.parseInt(map.get("total").toString());
            if (num > 0) {
                return true;
            }
        }
        return false;
    }


    @Override
    public String checkPGDynamic(Long templateId, Long orgId, Long activityId) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select oid from risk_dynamic_panel t where t.activityId=" + activityId + " and t.templateId=" + templateId + " and t.orgId=" + orgId;
        Map<String, Object> map = queryMap(sql, wrapper);
        if (map != null) {
            String oid = map.get("oid").toString();
            return oid;
        }
        return null;
    }

    @Override
    public int updateDynamicShowStatus(Long activityId, String showStatus) {
        String sql = "update risk_dynamic_panel set isShow='" + showStatus + "',updateOn=NOW() where activityId='" + activityId + "' and isShow='" + DictConst.N + "'";
        return this.executeSqlUpdate(sql);
    }
}
