package com.bcxin.risk.compose.source;

import com.bcxin.risk.base.dao.BaseDao;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.compose.dto.search.ComposeVenueSearchDto;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public class VenueBaseDaoImpl extends DaoImpl<VenueBase> implements VenueBaseDao {

	@Autowired
	private BaseDao baseDao;

	@Override
	public List<VenueBase> queryVenueList(ComposeVenueSearchDto searchDto, Page page){
		List<Criterion> criterionList = Lists.newArrayList();

		if(StringUtil.isNotEmpty(searchDto.getVenueType())) {
			criterionList.add(Restrictions.eq("venueType",searchDto.getVenueType()));
		}
		if(StringUtil.isNotEmpty(searchDto.getProvince())) {
			criterionList.add(Restrictions.eq("province",searchDto.getProvince()));
		}
		if(StringUtil.isNotEmpty(searchDto.getCity())) {
			criterionList.add(Restrictions.eq("city",searchDto.getCity()));
		}
		if(StringUtil.isNotEmpty(searchDto.getName())) {
			criterionList.add(Restrictions.like("name","%"+searchDto.getName()+"%"));
		}

		Disjunction dis = Restrictions.disjunction();
		Conjunction con = Restrictions.conjunction();
		dis.add(Restrictions.eq("nature","0"));

		con.add(Restrictions.eq("nature","1"));
		con.add(Restrictions.eq("userId",searchDto.getUserId()));
		dis.add(con);
		criterionList.add(dis);
		if (page == null) {
			return selectList(criterionList);
		}

		return selectPage(criterionList, page);
	}

	@Override
	public List<VenueBase> queryVenueListBySql(ComposeVenueSearchDto searchDto, Page page){
		StringBuffer sql = new StringBuffer("select vb.oid,vb.`name`,vb.province,sr1.province as 'provinceName',vb.city,sr2.city as 'cityName',vb.phone,vb.venueAddress,vb.nature,vb.parentId,vb.userId,vb.venueType from venue_base vb");
		sql.append(" LEFT JOIN sys_region sr1 on vb.province = sr1.oid");
		sql.append(" LEFT JOIN sys_region sr2 on vb.city = sr2.oid");
		sql.append(" where 1=1");

		if(StringUtil.isNotEmpty(searchDto.getVenueType())) {
			sql.append(" and vb.venueType='"+searchDto.getVenueType()+"'");
		}
		if(StringUtil.isNotEmpty(searchDto.getProvince())) {
			sql.append(" and vb.province='"+searchDto.getProvince()+"'");
		}
		if(StringUtil.isNotEmpty(searchDto.getCity())) {
			sql.append(" and vb.city='"+searchDto.getCity()+"'");
		}
		if(StringUtil.isNotEmpty(searchDto.getName())) {
			sql.append(" and vb.name like'%"+searchDto.getName()+"%'");
		}

		sql.append(" and (vb.nature='0' or (vb.nature='1' and vb.userId='"+searchDto.getUserId()+"'))");

		if(page != null){
			List list = baseDao.findBySQL(sql.toString(), null);
			page.setTotal(list.size());

			sql.append(" limit "+page.getSize()*(page.getCurrent()-1)+","+page.getSize());
		}
		List list = baseDao.findBySQL(sql.toString(), null);

		return list;
	}

	@Override
	public VenueBase findVenue(VenueBase venueBase) {
		List<Criterion> criterionList = Lists.newArrayList();

		if(StringUtil.isNotEmpty(venueBase.getVenueType())) {
			criterionList.add(Restrictions.eq("venueType",venueBase.getVenueType()));
		}
		if(StringUtil.isNotEmpty(venueBase.getProvince())) {
			criterionList.add(Restrictions.eq("province",venueBase.getProvince()));
		}
		if(StringUtil.isNotEmpty(venueBase.getCity())) {
			criterionList.add(Restrictions.eq("city",venueBase.getCity()));
		}
		if(StringUtil.isNotEmpty(venueBase.getName())) {
			criterionList.add(Restrictions.eq("name",venueBase.getName()));
		}

		List<VenueBase> list = selectList(criterionList);
		if(list != null && list.size() > 0){
			return list.get(0);
		}
		return null;
	}

	@Override
	public List<VenueBase> getVenueByType(ComposeVenueSearchDto searchDto) {
		List<Criterion> criterionList = Lists.newArrayList();

		if(searchDto.getUserId() != null) {
			criterionList.add(Restrictions.eq("userId",searchDto.getUserId()));
		}
		if(StringUtil.isNotEmpty(searchDto.getVenueType())) {
			criterionList.add(Restrictions.eq("venueType",searchDto.getVenueType()));
		}
		if(StringUtil.isNotEmpty(searchDto.getNature())) {
			criterionList.add(Restrictions.eq("nature",searchDto.getNature()));
		}

		return selectList(criterionList);
	}

}
