package com.bcxin.risk.compose.source;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.compose.dto.search.ComposeWeatherSearchDto;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * Created by Administrator on 2018/06/13 0013.
 */
@Repository
public class ComposeWeatherDaoImpl extends DaoImpl<ComposeWeather> implements ComposeWeatherDao {

    @Override
    public List<ComposeWeather> findListByBox(Page page, ComposeWeatherSearchDto searchDto) {
        List<Criterion> criterionList = Lists.newArrayList();

        if (searchDto.getProvinceId() != null) {
            criterionList.add(Restrictions.eq("provinceId", searchDto.getProvinceId()));
        }
        if (searchDto.getCityId() != null) {
            criterionList.add(Restrictions.eq("cityId", searchDto.getCityId()));
        }
        if (searchDto.getAreaId() != null) {
            criterionList.add(Restrictions.eq("areaId", searchDto.getAreaId()));
        }
        if (searchDto.getScenicId() != null) {
            criterionList.add(Restrictions.eq("scenicId", searchDto.getScenicId()));
        }
        if (StringUtil.isNotEmpty(searchDto.getName())) {
            criterionList.add(Restrictions.like("name", "%"+searchDto.getName()+"%"));
        }


        if (page == null) {
            return selectList(criterionList);
        }

        return selectPage(criterionList, page);
    }

    @Override
    public ComposeWeather findOneByComposeWeather(ComposeWeather composeWeather) {
        List<ComposeWeather> list = findByComposeWeather(composeWeather);
        if(list != null && list.size() > 0){
            return list.get(0);
        }
        return null;
    }

    @Override
    public List<ComposeWeather> findByComposeWeather(ComposeWeather composeWeather) {
        List<Criterion> criterionList = Lists.newArrayList();

        if (composeWeather.getProvinceId() != null) {
            criterionList.add(Restrictions.eq("provinceId", composeWeather.getProvinceId()));
        }else{
            criterionList.add(Restrictions.isNull("provinceId"));
        }
        if (composeWeather.getCityId() != null) {
            criterionList.add(Restrictions.eq("cityId", composeWeather.getCityId()));
        }else{
            criterionList.add(Restrictions.isNull("cityId"));
        }
        if (composeWeather.getAreaId() != null) {
            criterionList.add(Restrictions.eq("areaId", composeWeather.getAreaId()));
        }else{
            criterionList.add(Restrictions.isNull("areaId"));
        }
        if (composeWeather.getScenicId() != null) {
            criterionList.add(Restrictions.eq("scenicId", composeWeather.getScenicId()));
        }else{
            criterionList.add(Restrictions.isNull("scenicId"));
        }
        return selectList(criterionList);
    }
}
