package com.bcxin.risk.compose.source;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.compose.dto.search.ComposeRuleSearchDto;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * Created by Administrator on 2018/06/13 0013.
 */
@Repository
public class ComposeRuleDaoImpl extends DaoImpl<ComposeRule> implements ComposeRuleDao {

    @Override
    public List<ComposeRule> findListByBox(Page page, ComposeRuleSearchDto searchDto) {
        List<Criterion> criterionList = Lists.newArrayList();

        if (StringUtil.isNotEmpty(searchDto.getType())) {
            criterionList.add(Restrictions.eq("type", searchDto.getType()));
        }

        if (StringUtil.isNotEmpty(searchDto.getName())) {
            criterionList.add(Restrictions.like("name", "%"+searchDto.getName()+"%"));
        }

        if (page == null) {
            return selectList(criterionList);
        }

        return selectPage(criterionList, page);
    }
}
