package com.bcxin.risk.compose.source;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.compose.dto.search.ComposeRiskSearchDto;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * Created by Administrator on 2018/06/13 0013.
 */
@Repository
public class ComposeRiskDaoImpl extends DaoImpl<ComposeRisk> implements ComposeRiskDao {

    @Override
    public List<ComposeRisk> findListByBox(Page page, ComposeRiskSearchDto searchDto) {
        List<Criterion> criterionList = Lists.newArrayList();

        if (StringUtil.isNotEmpty(searchDto.getType())) {
            criterionList.add(Restrictions.eq("type", searchDto.getType()));
        }

        if (StringUtil.isNotEmpty(searchDto.getElement())) {
            criterionList.add(Restrictions.eq("element", searchDto.getElement()));
        }

        if (StringUtil.isNotEmpty(searchDto.getCatalog())) {
            criterionList.add(Restrictions.like("catalog", "%"+searchDto.getCatalog()+"%"));
        }
        if (StringUtil.isNotEmpty(searchDto.getFactor())) {
            criterionList.add(Restrictions.like("factor", "%"+searchDto.getFactor()+"%"));
        }
        if (StringUtil.isNotEmpty(searchDto.getTags())) {
            criterionList.add(Restrictions.like("tags", "%"+searchDto.getTags()+"%"));
        }
        if (StringUtil.isNotEmpty(searchDto.getKeyname())) {
            Disjunction dis = Restrictions.disjunction();
            dis.add(Restrictions.like("catalog", "%"+searchDto.getKeyname()+"%"));
            dis.add(Restrictions.like("factor", "%"+searchDto.getKeyname()+"%"));
            dis.add(Restrictions.like("tags", "%"+searchDto.getKeyname()+"%"));
            dis.add(Restrictions.like("suggest", "%"+searchDto.getKeyname()+"%"));
            criterionList.add(dis);
        }



        if (page == null) {
            return selectList(criterionList);
        }

        return selectPage(criterionList, page);
    }

}
