package com.bcxin.risk.compose.source;

import com.bcxin.risk.base.dao.BaseDao;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.compose.dto.search.ComposeCaseSearchDto;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public class ComposeCaseDaoImpl extends DaoImpl<ComposeCase> implements ComposeCaseDao {

    @Autowired
    private BaseDao baseDao;

    @Override
    public List<ComposeCase> findListByBox(Page page, ComposeCaseSearchDto searchDto) {
        List<Criterion> criterionList = Lists.newArrayList();

        if (StringUtil.isNotEmpty(searchDto.getType())) {
            criterionList.add(Restrictions.eq("type", searchDto.getType()));
        }

        if (StringUtil.isNotEmpty(searchDto.getActivityTypes())) {
            criterionList.add(Restrictions.eq("activityTypes", searchDto.getActivityTypes()));
        }

        if (StringUtil.isNotEmpty(searchDto.getVenueTypes())) {
            criterionList.add(Restrictions.eq("venueTypes", searchDto.getVenueTypes()));
        }

        if (StringUtil.isNotEmpty(searchDto.getCaseTime())) {
            criterionList.add(Restrictions.eq("caseTime", searchDto.getCaseTime()));
        }
        if (searchDto.getProvinceId() !=  null) {
            criterionList.add(Restrictions.eq("provinceId", searchDto.getProvinceId()));
        }
        if (searchDto.getCityId() !=  null) {
            criterionList.add(Restrictions.eq("cityId", searchDto.getCityId()));
        }
        if (searchDto.getAreaId() !=  null) {
            criterionList.add(Restrictions.eq("areaId", searchDto.getAreaId()));
        }

        if (page == null) {
            return selectList(criterionList);
        }

        return selectPage(criterionList, page);
    }

    @Override
    public List<ComposeCase> findListBySql(Page page, ComposeCaseSearchDto searchDto) {
        StringBuffer sql = new StringBuffer("select vb.*,sr1.province,sr2.city,sr3.area");
        sql.append(" from RISK_ComposeCase vb");
        sql.append(" LEFT JOIN sys_region sr1 on vb.provinceId = sr1.oid");
        sql.append(" LEFT JOIN sys_region sr2 on vb.cityId = sr2.oid");
        sql.append(" LEFT JOIN sys_region sr3 on vb.areaId = sr3.oid");
        sql.append(" where 1=1");

        if (StringUtil.isNotEmpty(searchDto.getType())) {
            sql.append(" and type='"+searchDto.getType()+"'");
        }

        if (StringUtil.isNotEmpty(searchDto.getActivityTypes())) {
            sql.append(" and activityTypes='"+searchDto.getActivityTypes()+"'");
        }

        if (StringUtil.isNotEmpty(searchDto.getVenueTypes())) {
            sql.append(" and venueTypes='"+searchDto.getVenueTypes()+"'");
        }

        if (StringUtil.isNotEmpty(searchDto.getCaseTime())) {
            sql.append(" and caseTime='"+searchDto.getCaseTime()+"'");
        }
        if (searchDto.getProvinceId() !=  null) {
            sql.append(" and provinceId='"+searchDto.getProvinceId()+"'");
        }
        if (searchDto.getCityId() !=  null) {
            sql.append(" and cityId='"+searchDto.getCityId()+"'");
        }
        if (searchDto.getAreaId() !=  null) {
            sql.append(" and areaId='"+searchDto.getAreaId()+"'");
        }

        if(page != null){
            List list = baseDao.findBySQL(sql.toString(), null);
            page.setTotal(list.size());
            sql.append(" limit "+page.getSize()*(page.getCurrent()-1)+","+page.getSize());
        }
        List list = baseDao.findBySQL(sql.toString(), null);

        return list;
    }

}
