package com.bcxin.risk.compose.draft;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.compose.dto.data.ComposeTaskDataDto;
import com.bcxin.risk.compose.dto.data.TaskUserDto;
import com.bcxin.risk.compose.dto.search.ComposeTaskSearchDto;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.report.domain.Report;
import com.bcxin.risk.user.domain.User;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.beanutils.BeanUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Repository
public class ComposeTaskDaoImpl extends DaoImpl<ComposeTask> implements ComposeTaskDao {


    @Override
    public ComposeTask findById(long id) {
        return selectById(id);
    }

    @Override
    public List<ComposeTask> findComposeTaskList(ComposeTaskSearchDto searchDto, Page page) {
        List<Criterion> criterionList = Lists.newArrayList();
        if (searchDto.getActivity() != null) {
            criterionList.add(Restrictions.eq("activity", searchDto.getActivity()));
        }
        if (searchDto.getUser() != null) {
            criterionList.add(Restrictions.eq("assgin", searchDto.getUser()));
        }

        if (page == null) {
            Order order = Order.asc("seq");
            return selectList(criterionList,order);
        }

        Order order = null;
        if(StringUtil.isNotEmpty(page.getOrderByField())){
            if(page.isAsc()){
                order = Order.asc(page.getOrderByField());
            }else{
                order = Order.desc(page.getOrderByField());
            }
        }
        return selectPage(criterionList, page, order);
    }

    /**
     * 评估机构分配任务
     * @param composeTaskSearchDto
     * @param page
     * @return
     */
    @Override
    public List<ComposeTaskDataDto> findAssignComposeTaskList(ComposeTaskSearchDto composeTaskSearchDto, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select " +
                " a.oid activityId," +
                " r.oid reportId," +
                " a.`name` AS activityName, " +
                " DATE_FORMAT(a.createOn,'%Y-%m-%d %H:%i:%s') AS createOn, " +
                " DATE_FORMAT(a.startDate,'%Y-%m-%d %H:%i:%s') AS startDate, " +
                " dict.label as activityType, " +
                " r.reportUrgent, " +
                " o.orderStatus, " +
                " r.reportSubStatus, " +
                " IFNULL((SELECT n.realName FROM RISK_task m,RISK_se_user n WHERE m.assgin_id = n.oid AND m.taskStatus in ('2','6') AND m.activity_id=a.oid limit 1),'') AS assgin_name, " +
                " a.number " +
                " FROM risk_activity a " +
                " inner JOIN risk_orderform o ON o.activity_id = a.oid " +
                " inner JOIN risk_activity_cooper ac ON ac.activity_id = a.oid " +
                " inner JOIN risk_report r ON r.activity_id = a.oid " +
                " inner JOIN sys_dict dict ON dict.value = a.activityType and dict.type = 'ActivityType' " ;

        /* or 条件必须放在最前面，不然会出现重复记录 */
        wrapper.or("(o.orderStatus = "+DictConst.ORDERSTATUS_YZF+" or o.orderStatus = "+DictConst.ORDERSTATUS_YHZF+"" +
                " or o.orderStatus = "+DictConst.ORDERSTATUS_REFUND+")");
        /* 过滤报备的活动 */
        wrapper.eq("a.isBackup",DictConst.N);

        if (StringUtil.isNotEmpty(composeTaskSearchDto.getReportSubStatus())) {
            wrapper.eq("r.reportSubStatus",composeTaskSearchDto.getReportSubStatus());
        } else {
            if (StringUtil.isNotEmpty(composeTaskSearchDto.getActiveStatus())) {
                if (DictConst.Y.equals(composeTaskSearchDto.getActiveStatus())) {
                    wrapper.eq("r.reportSubStatus",DictConst.REPORTSUBSTATUS_COMPLETE);
                } else if (DictConst.N.equals(composeTaskSearchDto.getActiveStatus())) {
                    wrapper.notIn("r.reportSubStatus",DictConst.REPORTSUBSTATUS_COMPLETE);
                }
            }
        }
        if (StringUtil.isNotEmpty(composeTaskSearchDto.getReportUrgent())) {
            wrapper.eq("r.reportUrgent",composeTaskSearchDto.getReportUrgent());
        }
        if (StringUtil.isNotEmpty(composeTaskSearchDto.getKey())) {
            wrapper.like("a.name",composeTaskSearchDto.getKey());
            page.setCurrent(0);
        }
        wrapper.eq("ac.org_id",composeTaskSearchDto.getUser().getOrg().getOid());

        wrapper.orderBy("a.createOn", false);
        List<ComposeTaskDataDto> dtoList = Lists.newArrayList();
        Page<Map<String, Object>> pageList = queryMapsPage(sql, wrapper, page);
        List<Map<String, Object>> list = pageList.getRecords();
        list.forEach(result -> {
            ComposeTaskDataDto dto = new ComposeTaskDataDto(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }


    /**
     * 撰写，一审，等的任务列表
     * @param composeTaskSearchDto
     * @param page
     * @return
     */
    @Override
    public List<ComposeTaskDataDto> findComposeTaskDTOList(ComposeTaskSearchDto composeTaskSearchDto, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select" +
                " IFNULL(cn.otherZX,0) as otherZXZJ," +
                " a.oid activityId," +
                " ct.oid taskId," +
                " r.oid reportId," +
                " a.`name` AS activityName, " +
                " DATE_FORMAT(a.createOn,'%Y-%m-%d %H:%i:%s') AS createOn, " +
                " DATE_FORMAT(a.startDate,'%Y-%m-%d %H:%i:%s') AS startDate, " +
                " dict.label as activityType, " +
                " r.reportUrgent, " +
                " r.reportSubStatus, " +
                " a.number, " +
                " t.taskStatus, " +
                " t.acceptStatus, "+
                " IFNULL((SELECT realName FROM RISK_se_user WHERE oid = t.assgin_id),'') AS assgin_name, "+
                " DATE_FORMAT(r.assignDate,'%Y-%m-%d %H:%i:%s') AS assignDate, " +
                " DATE_FORMAT(t.acceptDate,'%Y-%m-%d %H:%i:%s') AS acceptDate, " +
                " r.frame_id as frameId, " +
                " r.signature,K.taskQuote " +
                " FROM risk_activity a " +
                " inner JOIN risk_report r ON r.activity_id = a.oid " +
                " inner JOIN sys_dict dict ON dict.value = a.activityType and dict.type= 'ActivityType' " +
                " inner JOIN risk_task t ON  t.activity_id = a.oid " +
                " inner JOIN risk_composetask ct ON  ct.oid = t.oid " +
                /* 过滤掉已退款的订单 */
                " inner JOIN risk_orderForm o ON o.activity_id = a.oid and o.orderStatus != "+DictConst.ORDERSTATUS_REFUND+
                /* 增加验证是否还有其他撰写人员 */
                " left join ( "+
                " select activity_id,count(1) otherZX from risk_task t where t.taskType=6 and taskStatus!=3 and assgin_id!=" +composeTaskSearchDto.getUser().getOid()+
                " group by activity_id"+
                " ) cn on cn.activity_id=t.activity_id "+

                " left join (" +
                " select activityId,userId,taskQuote from risk_expertorderform_public where taskType='100' " +
                " ) K on K.activityId=a.oid and K.userId=t.assgin_id ";

        if (StringUtil.isNotEmpty(composeTaskSearchDto.getReportSubStatus())) {
            wrapper.eq("r.reportSubStatus",composeTaskSearchDto.getReportSubStatus());
        } else {
            if (StringUtil.isNotEmpty(composeTaskSearchDto.getActiveStatus())) {
                if (DictConst.Y.equals(composeTaskSearchDto.getActiveStatus())) {
                    wrapper.eq("t.taskStatus",DictConst.TASKSTATUS_COMPLETE);
                } else if (DictConst.N.equals(composeTaskSearchDto.getActiveStatus())) {
                    wrapper.eq("t.taskStatus",DictConst.TASKSTATUS_CONTINUE);
                }
            }
        }
        if (StringUtil.isNotEmpty(composeTaskSearchDto.getReportUrgent())) {
            wrapper.eq("r.reportUrgent",composeTaskSearchDto.getReportUrgent());
        }
        if (StringUtil.isNotEmpty(composeTaskSearchDto.getKey())) {
            wrapper.like("a.name",composeTaskSearchDto.getKey());
            page.setCurrent(0);
        }
        if (StringUtil.isNotEmpty(composeTaskSearchDto.getTaskStatus())){
            wrapper.eq("t.taskStatus",composeTaskSearchDto.getTaskStatus());
        }
        wrapper.eq("t.assgin_id",composeTaskSearchDto.getUser().getOid());

        wrapper.orderBy("t.acceptDate", false);
        List<ComposeTaskDataDto> dtoList = Lists.newArrayList();
        Page<Map<String, Object>> pageList = queryMapsPage(sql, wrapper, page);
        List<Map<String, Object>> list = pageList.getRecords();
        list.forEach(result -> {
            ComposeTaskDataDto dto = new ComposeTaskDataDto(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }

    @Override
    public Map<String, Object> countCompose(User user) {
        if (user == null) {
            return Maps.newHashMap();
        }

        SelectWrapper selectWrapper = new SelectWrapper();
        StringBuffer sql = new StringBuffer();
        StringBuffer sqlWhere = new StringBuffer(" WHERE");
        sql.append(" SELECT IFNULL(count(taskStatus),0) as total,IFNULL(sum(case  when rt.taskStatus = '3' then 1 else 0  end),0) as complete,");
        sql.append(" IFNULL(sum(case  when rt.taskStatus = '2' or rt.taskStatus = '1' then 1 else 0 end),0) as uncomplete");
        sql.append(" FROM risk_task rt");
        sql.append(" INNER JOIN risk_composetask rc on rt.oid=rc.oid");
        if(DictConst.USERTYPE_DSFFWJGYH.equals(user.getUserType()) || DictConst.USERTYPE_DSFFWJGYH_ZG.equals(user.getUserType())){
            sql.append(" INNER JOIN risk_se_user rsu on rsu.oid= rt.assgin_id and rsu.active=1");
            sqlWhere.append(" rsu.org_id="+user.getOrg().getOid());
        }else{
            sqlWhere.append(" rt.assgin_id ="+user.getOid());
        }

        sql.append(sqlWhere);
        return queryMap(sql.toString(), selectWrapper);
    }

    @Override
    public Map<String, String> countExpertCompose() {
        SelectWrapper selectWrapper = new SelectWrapper();
        StringBuffer sql = new StringBuffer(
                " select " +
                        " sum(case  when r.taskStatus = '3' then 1 else 0  end) as complete, " +
                        " sum(case  when r.taskStatus = '2' then 1 else 0 end) as uncomplete " +
                        " from risk_task r inner join risk_se_user u on r.assgin_id = u.oid WHERE u.userType = '2' ");

        Map<String, String> countMap = Maps.newHashMap();
        Map<String, Object> result = queryMap(sql.toString(), selectWrapper);
        countMap.put("complete", result.get("complete") == null ? "0"
                : result.get("complete").toString());
        countMap.put("uncomplete", result.get("uncomplete") == null ? "0"
                : result.get("uncomplete").toString());
        return countMap;
    }

    @Override
    public ComposeTaskDataDto findComposeUser(ComposeTaskSearchDto searchDto){
        SelectWrapper wrapper = new SelectWrapper();
        String sql = " select u.userName,u.realName as assgin_name,u.oid as assgin_id" +
                " ,u.phone as assgin_phone,u.email as assgin_email,u.signature as assgin_sign from risk_composetask t " +
                " inner join risk_task tt on tt.oid = t.oid " +
                " inner join risk_se_user u on u.oid = tt.assgin_id " ;
        if (searchDto == null) {
            return null;
        }
        if (StringUtil.isNotEmpty(searchDto.getTaskType())) {
            wrapper.eq("taskType",searchDto.getTaskType());
        }
        if (searchDto.getActivity() != null ) {
            wrapper.eq("activity_id",searchDto.getActivity().getOid());
        }
        Map<String, Object> result = queryMap( sql,wrapper);
        return new ComposeTaskDataDto(result);

    }

    @Override
    public void backCompose(Long activityId){
        executeSqlUpdate("update risk_report set reportSubStatus = 3,approvalFlag = '' where activity_id =  " + activityId);
        System.out.println("语句执行："+"update risk_report set reportSubStatus = 3,approvalFlag = '' where activity_id =  " + activityId);
    }

    @Override
    public void delete(Long activityId, String taskType) {
        StringBuffer whereSql = new StringBuffer();
        whereSql.append(" where activity_id='"+activityId+"'");
        whereSql.append(" and taskType='"+taskType+"'");
        whereSql.append(" and taskStatus='1'");

        StringBuffer sql = new StringBuffer("DELETE FROM risk_composetask where oid in (");
        sql.append("select oid from risk_task");
        sql.append(whereSql);
        sql.append(")");

        executeSqlUpdate(sql.toString());
        System.out.println("语句执行："+sql.toString());

        sql = new StringBuffer("DELETE FROM risk_task");
        sql.append(whereSql);
        executeSqlUpdate(sql.toString());
        System.out.println("语句执行："+sql.toString());
    }

    @Override
    public void deleteByIds(List<String> ids){
        if(ids==null || ids.isEmpty()){
            return;
        }
        String idStr="";
        for(String s : ids){
            idStr+=s+",";
        }
        if(StringUtil.isNotEmpty(idStr) && idStr.length()>0){
            idStr=idStr.substring(0,idStr.length()-1);
        }
        StringBuffer sql = new StringBuffer("DELETE FROM risk_composetask where oid in (");
        sql.append(idStr);
        sql.append(")");
        executeSqlUpdate(sql.toString());
        System.out.println("语句执行："+sql.toString());

        StringBuffer sql1 = new StringBuffer("DELETE FROM risk_task where oid in (");
        sql1.append(idStr);
        sql1.append(")");
        executeSqlUpdate(sql1.toString());
        System.out.println("语句执行："+sql1.toString());
    }

    @Override
    public List<ComposeTask> findDoListByActivityIdAndTaskType(Activity activity,String taskType) {
        List<Criterion> criterionList = Lists.newArrayList();
        if (activity != null) {
            criterionList.add(Restrictions.eq("activity", activity));
        }
        if (StringUtil.isNotEmpty(taskType)) {
            criterionList.add(Restrictions.eq("taskType", taskType));
        }
        criterionList.add(Restrictions.ne("taskStatus", DictConst.TASKSTATUS_NON));


        return selectList(criterionList,Order.asc("acceptDate"));
    }


    @Override
    public List<ComposeTask> findByActivity(Activity activity) {
        List<Criterion> criterionList = Lists.newArrayList();
        if (activity != null) {
            criterionList.add(Restrictions.eq("activity", activity));
        }
        return selectList(criterionList,Order.asc("seq"));
    }

    @Override
    public List<ComposeTask> findByActivityAndType(Activity activity,String taskType) {
        List<Criterion> criterionList = Lists.newArrayList();
        if (activity != null) {
            criterionList.add(Restrictions.eq("activity", activity));
        }
        criterionList.add(Restrictions.eq("taskType", taskType));
        return selectList(criterionList,Order.asc("seq"));
    }

    @Override
    public List<TaskUserDto> findTaskUserByActivity(Activity activity) {
        StringBuffer sql = new StringBuffer("select rc.oid as 'taskId',rt.activity_id as activityId,rt.taskType,u.oid as 'userId', u.realName, u.signature, e.expertCategory,u.esignId,rt.name,rc.seq,u.phone from risk_composetask rc");
        sql.append(" INNER JOIN risk_task rt on rc.oid=rt.oid");
        sql.append(" INNER JOIN risk_se_user u on rt.assgin_id = u.oid and u.active=1");
        sql.append(" LEFT JOIN risk_expertuser e on u.oid=e.oid");
        sql.append(" where rt.taskStatus!=1 and rt.activity_id="+activity.getOid());
        sql.append(" order by  rc.seq");
//        sql.append(" order by rt.taskType,rc.seq");

        List<Map<String, Object>> list = queryMaps(sql.toString());
        List<TaskUserDto> dtoList = new ArrayList<>();

        list.forEach(result ->{
            try {
                TaskUserDto dto = new TaskUserDto();
                BeanUtils.populate(dto,result);
                dtoList.add(dto);
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            } catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        });
        return dtoList;
    }



    /**
     * 获取专家订单
     * @param composeTaskSearchDto
     * @param page
     * @return
     */
    @Override
    public List<ComposeTaskDataDto> findExpertOrderList(ComposeTaskSearchDto composeTaskSearchDto, Page page){
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select "+
                     "G.userName,"+
                     "G.realName,"+
                     "A.oid as activityId,"+
                     "A.activitySource,"+
                     "B.oid as taskId,"+
                     "D.oid as expertOrderId,"+
                     "B.assgin_id as userId,"+
                     "A.name as activityName,"+
                     "A.activitySource,"+
                     "DATE_FORMAT(A.createOn,'%Y-%m-%d %H:%i:%s') AS createOn,"+
                     "DATE_FORMAT(A.startDate,'%Y-%m-%d %H:%i:%s') AS startDate,"+
                     "F.`label` as activityType,"+
                     "E.reportUrgent,"+
                     "E.reportSubStatus,"+
                     "DATE_FORMAT(E.assignDate,'%Y-%m-%d %H:%i:%s') AS assignDate,"+
                     "DATE_FORMAT(B.acceptDate,'%Y-%m-%d %H:%i:%s') AS acceptDate,"+
                     "B.acceptStatus,"+
                     "B.taskStatus,"+
                     "D.orderType"+
                     //"D.orderStatus as expertOrderStatus, "+
                     //"D.payment "+
                " from risk_activity A "+
                "inner join risk_task B on A.oid=B.activity_id "+
                "inner join risk_expertorderform D on D.user_id=B.assgin_id "+
                "inner JOIN risk_report E ON E.activity_id =A.oid "+
                "inner join sys_dict F on A.activityType = F.value and F.type = 'ActivityType' "+
                "inner join risk_se_user G on B.assgin_id=G.oid ";

        // 是否加急
        if(StringUtil.isNotEmpty(composeTaskSearchDto.getReportUrgent())){
            wrapper.eq("E.reportUrgent",composeTaskSearchDto.getReportUrgent());
        }
        // 专家订单状态
        if(StringUtil.isNotEmpty(composeTaskSearchDto.getExpertOrderStatus())){
            wrapper.eq("D.orderStatus",composeTaskSearchDto.getExpertOrderStatus());
        }
        // 订单任务类型
        if(StringUtil.isNotEmpty(composeTaskSearchDto.getOrderType())){
            wrapper.eq("D.orderType",composeTaskSearchDto.getOrderType());
        }

        if (StringUtil.isNotEmpty(composeTaskSearchDto.getKey())) {
            wrapper.like("A.name",composeTaskSearchDto.getKey());
            page.setCurrent(0);
        }
        String userType=composeTaskSearchDto.getUser().getUserType();
        // 如果是第三方评估机构
        if(userType.equals(DictConst.USERTYPE_DSFFWJGYH)){
            wrapper.eq(" G.org_id",composeTaskSearchDto.getUser().getOrg().getOid());
        }
        // 探勘专家、撰写专家，勘查人员
        else if(userType.equals(DictConst.USERTYPE_DSFFWJGYH_TKQT)
                || userType.equals(DictConst.USERTYPE_DSFFWJGYH_ZXZJ)
                || userType.equals(DictConst.USERTYPE_DSFFWJGYH_TKZJ)){
            wrapper.eq("B.assgin_id",composeTaskSearchDto.getUser().getOid());
        }else{
            wrapper.eq("B.assgin_id",composeTaskSearchDto.getUser().getOid());
        }

        wrapper.orderBy("B.acceptDate", false);
        List<ComposeTaskDataDto> dtoList = Lists.newArrayList();
        Page<Map<String, Object>> pageList = queryMapsPage(sql, wrapper, page);
        List<Map<String, Object>> list = pageList.getRecords();
        list.forEach(result -> {
            ComposeTaskDataDto dto = new ComposeTaskDataDto(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }

    /**
     * 统计专家订单
     * @param user
     * @return
     */
    @Override
    public Map<String,Object> countExpertOrder(User user){
        if (user == null) {
            return Maps.newHashMap();
        }
        //TODO 这里的统计有问题
        SelectWrapper selectWrapper = new SelectWrapper();
        StringBuffer sql = new StringBuffer();
        StringBuffer sqlWhere = new StringBuffer(" WHERE");
        sql.append("select ");
        sql.append("sum(0) as total,");
        sql.append("sum(0) as unHandlerOrder,");
        sql.append("sum(0) as confirmOrder,");
        sql.append("sum(0) as refuseOrder,");
        sql.append("sum(0) as settleOrder ");

        //sql.append("IFNULL(count(orderStatus),0) as total,");
        //sql.append("IFNULL(sum(case orderStatus when '0' then 1 else 0 end),0) as unHandlerOrder,");
        //sql.append("IFNULL(sum(case orderStatus when '1' then 1 else 0 end),0) as confirmOrder,");
        //sql.append("IFNULL(sum(case orderStatus when '2' then 1 else 0 end),0) as refuseOrder,");
        //sql.append("IFNULL(sum(case orderStatus when '5' then 1 else 0 end),0) as settleOrder ");

        sql.append(" from RISK_ExpertOrderForm ");
        sqlWhere.append(" user_id ="+user.getOid());
        sql.append(sqlWhere);
        return queryMap(sql.toString(), selectWrapper);
    }

    @Override
    public ComposeTask findByActivityAnUser(Activity activity,User user,String taskType){
        List<Criterion> criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq("activity", activity));
        criterionList.add(Restrictions.eq("assgin", user));
        criterionList.add(Restrictions.eq("taskType", taskType));
        List<ComposeTask> list=selectList(criterionList);
        if(list==null || list.isEmpty()){
            return null;
        }
        return list.get(0);
    }

    @Override
    public void updatePublicExpertStatus(Report report, String taskType, String taskStatus){
        Activity activity=report.getActivity();
        Long activityId=activity.getOid();
        Long reportId=report.getOid();
        String selSql="select A.oid from risk_task A,risk_expertuser B,RISK_ComposeTask C where A.assgin_id=B.oid and A.oid=C.oid and A.taskType="+taskType+" and A.activity_id="+activityId+" and taskStatus=1 order by C.seq asc limit 1";
        List<Map<String, Object>> list=this.queryMaps(selSql);
        if(list!=null && list.size()>0){
            Map<String, Object> map=list.get(0);
            if(map.containsKey("oid")){
                Long taskId=Long.parseLong(map.get("oid").toString());
                String sql="update risk_task set taskStatus='"+taskStatus+"' where oid="+taskId;
                int num=this.executeSqlUpdate(sql);

                // 更新关系
                String sql1="update RISK_ComposeFile set composeTask_id="+taskId+" where report_id="+reportId+" and `level`=3 and saved is null";
                num=this.executeSqlUpdate(sql1);
            }
        }
    }
}
