package com.bcxin.risk.common.dao;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.domain.SearchHistory;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * Created by Administrator on 2018/06/25 0025.
 */
@Repository
public class SearchHistoryDaoImpl extends DaoImpl<SearchHistory> implements SearchHistoryDao {

    @Override
    public List<SearchHistory> findListByBox(Page page, SearchHistory searchDto) {
        List<Criterion> criterionList = Lists.newArrayList();

        if (StringUtil.isNotEmpty(searchDto.getSearchType())) {
            criterionList.add(Restrictions.eq("searchType", searchDto.getSearchType()));
        }

        if (StringUtil.isNotEmpty(searchDto.getKeyName())) {
            criterionList.add(Restrictions.eq("keyName", searchDto.getKeyName()));
        }

        if(searchDto.getUserId() != null) {
            criterionList.add(Restrictions.eq("userId", searchDto.getUserId()));
        }

        if (page == null) {
            return selectList(criterionList);
        }

        Order order = Order.desc("createOn");


        return selectPage(criterionList, page, order);
    }

    @Override
    public SearchHistory findByKeyNameAndUserId(String keyName,Long userId) {
        List<Criterion> criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq("keyName",keyName));
        criterionList.add(Restrictions.eq("userId",userId));
        List<SearchHistory> list = selectList(criterionList);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }
}
