package com.bcxin.risk.common.dao;

import com.bcxin.risk.activity.dto.data.ActivityDataDTO;
import com.bcxin.risk.base.dao.BaseDaoImpl;
import com.bcxin.risk.base.dao.QueryHelper;
import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.constant.DictConst;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

@Repository("scheduleDao")
@SuppressWarnings("unchecked")
public class ScheduleDaoImpl extends BaseDaoImpl implements ScheduleDao {

    
	/**
	 * 
	 * <b>Function 查询需要将活动状态变成结束状态的活动</b> 
	 * 前置条件（活动状态为为结束；活动结束时间早于当前时间；已完成监理报告上传；已进行第三阶段勘查）
	 * @return
	 * @author LuoPeng
	 * @date 2016年12月21日 下午5:31:13
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public List<String> findNeedEndReport(){
		Map<String, Object> paramMap = Maps.newHashMap();

		/***  塞选活动置为结束状态的条件
		 *    1、已过活动时间
		 ***/


        StringBuilder sql = new StringBuilder("SELECT a.oid  " +
				"    FROM risk_activity a " +
				"    inner join risk_orderForm o on o.activity_id = a.oid" +
				"    WHERE SYSDATE() > a.endDate  " +
				"    AND a.activityStatus != '50' " +
				"    and o.orderStatus != 1 ");


		List<String> resultList = Lists.newArrayList();
		List<Object> list = QueryHelper.findBySql(sql.toString(), paramMap);
		for (Object object : list) {
			Map<String,Object> result = (Map<String,Object>)object;
			resultList.add(result.get("oid")==null?"":result.get("oid").toString());
		}
		return resultList;

	}
	
	
	/**
	 * 
	 * <b>Function 查询需要将活动状态变成结束状态的活动(单场活动)</b> 
	 * 前置条件（活动状态为为结束；活动结束时间早于当前时间；已完成监理报告上传；已进行第三阶段勘查）
	 * @return
	 * @author LuoPeng
	 * @date 2016年12月21日 下午5:31:13
	 * @注意事项 </b>
	 * <b>
	 */
	public List<String> findNeedEndReport(Long reportId){
		Map<String, Object> paramMap = Maps.newHashMap();
        StringBuilder sql = new StringBuilder("SELECT a.oid FROM risk_activity a "
				+ " inner join RISK_ActivityRecord r on r.activity_id = a.oid "
				+ " inner join risk_activityrecord rr on rr.activity_id = a.oid "
				+ " where 1=1 and endDate < sysdate() and a.activityStatus != '"+DictConst.ACTIVITYSTATUS_HDJS+"' ");
		
		if ( reportId == 0 ) {
			return Lists.newArrayList();
		} else {
			sql.append(" and a.oid = :ooid");
			paramMap.put("ooid", reportId);
		}
		
		sql.append(" and r.activitySubStep = :subStep");
		sql.append(" and rr.activitySubStep = :subStep2");
		paramMap.put("subStep", DictConst.ACTIVITYSUBSTEP_JLBGYWC);
		paramMap.put("subStep2", DictConst.ACTIVITYSUBSTEP_DSJDTKYWC);
		
		List<String> resultList = Lists.newArrayList();
		List<Object> list = QueryHelper.findBySql(sql.toString(), paramMap);
		for (Object object : list) {
			Map<String,Object> result = (Map<String,Object>)object;
			resultList.add(result.get("oid")==null?"":result.get("oid").toString());
		}
		return resultList;
	}
	
	

	

	/**
	 * 
	 * <b>Function 查询需要完成合同认证的活动</b> 
	 * 
	 * @return
	 * @author LuoPeng
	 * @date 2016年12月21日 下午5:31:13
	 * @注意事项 </b>
	 * <b>
	 */
	public List<ActivityDataDTO> findNeedCompleteContract(){
		Map<String, Object> paramMap = Maps.newHashMap();
        StringBuilder sql = new StringBuilder("SELECT a.oid,a.name,a.startDate,a.user_id as userId " +
				"  FROM risk_activity a ,risk_orderForm b " +
				" WHERE a.oid = b.activity_id " +
				"   AND b.orderStatus = '1' " +
				"   AND a.startDate >= DATE_ADD(sysdate() , interval 6 day)  " +
				"   AND a.startDate <= DATE_ADD(sysdate() , interval 8 day) " +
				"   AND EXISTS (SELECT 1 " +  //选择了风评机构，需要合同认证
				"                 FROM risk_activity_cooper c ,risk_serviceorg d " +
				"                WHERE c.org_id = d.oid " +
				"                  AND d.serviceOrgType = '1' " + //评估机构
				"                  AND c.activity_id = a.oid) " +
				"   AND NOT EXISTS (SELECT 1  " + //未进行合同认证
				"                     FROM risk_contract " +
				"                    WHERE activity_id = a.oid " +
				"                      AND active = '1')");
		
		List<ActivityDataDTO> resultList = Lists.newArrayList();

		List<Object> list = QueryHelper.findBySql(sql.toString(), paramMap);
		for (Object object : list) {
			Map<String,Object> result = (Map<String,Object>)object;
			ActivityDataDTO dto = new ActivityDataDTO(result);
			resultList.add(dto);
		}
		return resultList;
	}
	
	
	/**
	 * 
	 * <b>Function 查询需要完成合同认证的活动task中的查询，根据report来统计完成了多少合同项</b> 
	 * 
	 * @return
	 * @author LuoPeng
	 * @date 2016年12月21日 下午5:31:13
	 * @注意事项 </b>
	 * <b>
	 */
	public Map<String,String> countContractByActivity(String activityId){
		Map<String, Object> paramMap = Maps.newHashMap();
        StringBuilder sql = new StringBuilder("SELECT count(oid) as countContract FROM risk_contract where 1=1 ");
		
		if ( StringUtil.isEmpty(activityId) ) {
			return Maps.newHashMap();
		} else {
			sql.append(" and activity_id = :reportId");
			paramMap.put("reportId", Long.parseLong(activityId));
		}
		
		Map<String,String> map = Maps.newHashMap();
		List<Object> list = QueryHelper.findBySql(sql.toString(), paramMap);
		for (Object object : list) {
			Map<String,Object> result = (Map<String,Object>)object;
			map.put("countContract", result.get("countContract").toString());
		}
		return map;
	}
	
	/**
	 * 
	 * <b>Function 查询需要完成合同认证的活动task中的查询，根据report来统计多少服务提供商</b> 
	 * 
	 * @return
	 * @author LuoPeng
	 * @date 2016年12月21日 下午5:31:13
	 * @注意事项 </b>
	 * <b>
	 */
	public Map<String,String> countCooperByReport(String activityId){
		Map<String, Object> paramMap = Maps.newHashMap();
        StringBuilder sql = new StringBuilder("SELECT count(oid) as countCooper FROM RISK_Activity_Cooper where 1=1 ");
		
		if ( StringUtil.isEmpty(activityId) ) {
			return Maps.newHashMap();
		} else {
			sql.append(" and activity_id = :activityId");
			paramMap.put("activityId", Long.parseLong(activityId));
		}
		
		Map<String,String> map = Maps.newHashMap();
		List<Object> list = QueryHelper.findBySql(sql.toString(), paramMap);
		for (Object object : list) {
			Map<String,Object> result = (Map<String,Object>)object;
			map.put("countCooper", result.get("countCooper").toString());
		}
		return map;
	}
	
	/**
	 * 
	 * <b>Function 查询当天的进行的活动</b> 
	 * 
	 * @return
	 * @author LuoPeng
	 * @date 2016年12月21日 下午5:31:13
	 * @注意事项 </b>
	 * <b>
	 */
	public List<String> findNeedFixAddress(){
		Map<String, Object> paramMap = Maps.newHashMap();
		StringBuffer sql = new StringBuffer("select oid from risk_report where createOn > DATE_SUB(sysdate() , interval 1 day)" 
			+" and  createOn < sysdate() and oid not in ( select r.oid from risk_report_dedecmsaddress rd"
			+" inner join risk_reportextra e on rd.reportExtraId = e.oid"
			+" inner join risk_report r on r.oid = e.reportId"
			+" where r.createOn > DATE_SUB(sysdate() , interval 1 day) "
			+" and  r.createOn < sysdate() ) ");
		
		List<String> resultList = Lists.newArrayList();
		List<Object> list = QueryHelper.findBySql(sql.toString(), paramMap);
		for (Object object : list) {
			Map<String,Object> result = (Map<String,Object>)object;
			String temp = result.get("oid")==null?"":result.get("oid").toString();
			resultList.add(temp);
		}
		if ( CollectionUtil.isNotEmpty(resultList) ) {
			Map<String, Object> paramMap2 = Maps.newHashMap();
			StringBuffer sql2 = new StringBuffer("select e.oid,d.address from risk_report r"
				+" inner join risk_reportextra e on e.reportId = r.oid "
				+" inner join risk_reportdetail d on d.reportId = r.oid ");
			
			List<String> resultList2 = Lists.newArrayList();
			List<Object> list2 = QueryHelper.findBySql(sql2.toString(), paramMap2);
			for (Object object : list2) {
				Map<String,Object> result = (Map<String,Object>)object;
				String temp = result.get("oid")==null?"":result.get("oid").toString();
				String temp2 = result.get("address")==null?"":result.get("address").toString();
				resultList.add(temp);
			}
		}
		return resultList;
	}
}
