package com.bcxin.risk.common.dao;


import com.bcxin.risk.base.dao.BaseDao;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.domain.Regionalization;
import com.bcxin.risk.common.dto.data.RegionalizationDataDto;
import com.bcxin.risk.common.dto.search.RegionalizationSearchDto;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

@Repository("regionalizationDao")
public class RegionalizationDaoImpl extends DaoImpl<Regionalization> implements RegionalizationDao {

    @Autowired
    private BaseDao baseDao;

    @Override
    public List findRegionalizationByDto(RegionalizationSearchDto searchDto, DwzPage page) {

        String sql = "SELECT  oid , name,address,DATE_FORMAT(createOn, '%Y-%m-%d %H:%i:%s') AS createOn,phone ," +
                "             DATE_FORMAT(updateOn, '%Y-%m-%d %H:%i:%s') AS updateOn ,"+
                "            (SELECT b.province FROM sys_region b WHERE a.province_id = b.oid) province," +
                "            (SELECT b.city FROM sys_region b WHERE a.city_id = b.oid) city," +
                "            (SELECT b.area FROM sys_region b WHERE a.area_id = b.oid) area" +
                "       FROM risk_regionalization a where 1=1 ";

        SelectWrapper wrapper = SelectWrapper.instance();
        if (StringUtil.isNotEmpty( searchDto.getName() )) {
            sql += " and name   like '%" + searchDto.getName()+"%' ";
        }
        if (StringUtil.isNotEmpty(searchDto.getAddress()) ) {
            sql += " and address  like '%" + searchDto.getAddress()+"%' ";
        }
        if (StringUtil.isNotEmpty(searchDto.getPhone()) ) {
            sql += " and phone  like '%" + searchDto.getPhone()+"%' ";
        }
        if (StringUtil.isNotEmpty(searchDto.getProvince_id()  ) ) {
            sql += " and province_id = " + searchDto.getProvince_id();
        }
        if (StringUtil.isNotEmpty(searchDto.getCity_id() )  ) {
            sql += " and city_id = " + searchDto.getCity_id();
        }
        if (StringUtil.isNotEmpty(searchDto.getArea_id()) ) {
            sql += " and area_id = " + searchDto.getArea_id();
        }
        if (StringUtil.isNotEmpty(searchDto.getFlag())){
            if (!StringUtil.isNotEmpty(searchDto.getArea_id() )  ) {
                sql += " and area_id IS NULL " ;
            }
        }

        sql = sql + " ORDER BY oid DESC" ;
        if(page!= null ){
            page.setTotalCount(querySqlCounts( sql,  wrapper));
            sql = sql + " limit "+(page.getPageNum() - 1) * page.getNumPerPage()+","+page.getNumPerPage();
        }


        List<RegionalizationDataDto> dtoList = Lists.newArrayList();
        List<Map<String, Object>> list = queryMaps(sql, wrapper);
        list.forEach(result -> {
            RegionalizationDataDto dto = new RegionalizationDataDto(result);
            dtoList.add(dto);
        });
        return dtoList;

    }

    @Override
    public Regionalization findRegionalizationByOid(Long oid) {
        return selectById(oid);
    }
}
