package com.bcxin.risk.common.dao;

import com.bcxin.risk.common.domain.Region;
import com.bcxin.risk.common.dto.data.RegionDataDto;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.hibernate.criterion.Order;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * Created by PVer on 2017/4/24.
 */
@Repository
@Slf4j
public class RegionDaoImpl extends DaoImpl<Region> implements RegionDao{


    @Override
    public List<Region> selectRegionList(){
        Order[] orders = new Order[2];
        orders[0] = Order.asc("seq");
        orders[1] = Order.asc("oid");
       return selectList(orders);
    }

    @Override
    public List<Region> selectProvinceRegionList(){
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("level", DictConst.REGIONLEVEL_PROVINCE);
        wrapper.orderBy("seq",true);
        return selectList(wrapper);
    }

    @Override
    public List<Region> selectCityRegionList(){
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("level", DictConst.REGIONLEVEL_CITY);
        wrapper.orderBy("seq",true);
        return selectList(wrapper);
    }

    @Override
    public List<Region> selectAreaRegionList(){
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("level", DictConst.REGIONLEVEL_AREA);
        wrapper.orderBy("seq",true);
        return selectList(wrapper);
    }

    @Override
    public List<Region> selectUnitRegionList(){
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("level", DictConst.REGIONLEVEL_UNIT);
        wrapper.orderBy("seq",true);
        return selectList(wrapper);
    }

    // 查找服务机构已选的城市
    @Override
    public List<RegionDataDto> queryRegion(Long oid) {

        String sql = "SELECT a.oid," +
                             "(CASE WHEN a.level = '1' " +
                                    "THEN a.province " +
                                    "WHEN a.level = '2' " +
                                    "THEN a.city " +
                                    "ELSE a.area END ) AS area," +
                             "a.parent_id," +
                             "a.level," +
                            "(CASE WHEN (SELECT COUNT(1) " +
                                            "FROM risk_org_region " +
                                           "WHERE region_id = a.oid " +
                                             "AND org_id = "+ oid +")>0 " +
                                   "THEN 1 " +
                                   "ELSE 0 END) AS xzbz " +
                        " FROM sys_region a " +
                        "WHERE a.level != '3' " ;
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.orderBy("a.oid", true);
        List<Map<String, Object>> list =  queryMaps( sql,  wrapper);
        List<RegionDataDto> dtoList = Lists.newArrayList();
        list.forEach(result -> {
            Map<String, Object> map = (Map<String, Object>) result;
            RegionDataDto dto = new RegionDataDto(map);
            dtoList.add(dto);
        });
        return dtoList ;
    }

    @Override
    public Region findRegionByname(String name){
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.or("city = '"+name+"' or province = '"+name+"'");
        return  selectOne(wrapper);
    }

    @Override
    public Region findRegionByOid(Long oid){
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("oid",oid);
        return selectById(oid);
    };

    @Override
    public List<Region> findRegionByParentId(String parentId){
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("parent_id",parentId);
        wrapper.orderBy("seq,oid",true);
        return selectList(wrapper);
    }

    @Override
    public List<RegionDataDto> getAllRegion() {
        String sql = "SELECT" +
                "        a.oid," +
                "        (CASE " +
                "            WHEN a.level = '1' THEN a.province " +
                "            WHEN a.level = '2' THEN a.city " +
                "            ELSE a.area " +
                "        END ) AS area," +
                "        a.parent_id," +
                "        a.level" +
                "    FROM" +
                "        sys_region a " +
                "    WHERE" +
                "        a.level != '3' ";
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.orderBy("a.oid", true);
        List<Map<String, Object>> list =  queryMaps( sql,  wrapper);
        List<RegionDataDto> dtoList = Lists.newArrayList();
        list.forEach(result -> {
            Map<String, Object> map = (Map<String, Object>) result;
            RegionDataDto dto = new RegionDataDto(map);
            dtoList.add(dto);
        });
        return dtoList ;
    }


}
