package com.bcxin.risk.common.dao;

import com.bcxin.risk.common.domain.OrgRegion;
import com.bcxin.risk.common.dto.data.OrgRegionDataDto;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.org.domain.ServiceOrg;
import com.bcxin.risk.user.domain.RoleMenu;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;


@Repository
@Slf4j
public class OrgRegionDaoImpl extends DaoImpl<OrgRegion> implements OrgRegionDao{


    public void deleteOrgRegion(OrgRegion orgRegion){
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("org_id", orgRegion.getOrg_id());
        delete(wrapper);
    }

    /**
     * 批量插入机构服务区域
     * @param orgRegionList
     */

    @Override
    public void insertOrgRegionList(List<OrgRegion> orgRegionList){
        String sql = "INSERT INTO risk_org_region (createOn,"+
                                                      "region_level,"+
                                                      "org_id,"+
                                                      "region_id)"+
                                           " VALUES ";
        for(OrgRegion orgRegion : orgRegionList){
            sql += "(SYSDATE(),'"+ orgRegion.getRegion_level() +"',"+ orgRegion.getOrg_id() +","+ orgRegion.getRegion_id() +"),";
        }
        sql = sql.substring(0,sql.length()-1);
        executeSqlUpdate(sql);
    }

    /**
     * 插入机构服务区域
     * @param orgRegion
     */
    public void insertOrgRegion(OrgRegion orgRegion){
        save(orgRegion);
    }

    @Override
    public List<OrgRegionDataDto> findByOrg(Long oid) {
        String sql = "select region_id FROM risk_org_region WHERE org_id = "+oid +"" ;
        SelectWrapper wrapper = SelectWrapper.instance();
        List<Map<String, Object>> list =  queryMaps( sql,  wrapper);
        List<OrgRegionDataDto> dtoList = Lists.newArrayList();
        list.forEach(result -> {
            Map<String, Object> map = (Map<String, Object>) result;
            OrgRegionDataDto dto = new OrgRegionDataDto(map);
            dtoList.add(dto);
        });
        return dtoList ;

    }


    public OrgRegion findOrgRegionByOid(Long oid){
        //return selectOne(Restrictions.eq("oid", oid));
        return selectById(oid);
    }

    @Override
    public List<OrgRegion> findOrgRegionByOrg(Long oid) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("org_id",oid);
        return  selectList(wrapper);
    }





}
