package com.bcxin.risk.common.dao;

import com.bcxin.risk.common.domain.Dict;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
@Slf4j
public class DictDaoImpl extends DaoImpl<Dict> implements DictDao{

    @Override
    public List<Dict> selectDictList(){
        return selectList();
    }

    @Override
    public List<Dict> listDictByTypeString(List typeList) {
        List<Criterion> criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.in("type", typeList));
        List<Dict> list = selectList(criterionList);
        return list;
    }
}
