package com.bcxin.risk.base.dao;

import com.bcxin.risk.base.domain.SystemConfig;
import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * Created by PVer on 2017/4/24.
 */
@Repository
@Slf4j
public class SystemConfigDaoImpl extends DaoImpl<SystemConfig> implements SystemConfigDao {

    @Override
    public List<SystemConfig> selectConfigList(){
        return selectList();
    }

    @Override
    public SystemConfig selectConfig(String key){
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("syskey",key);
        List<SystemConfig> list = selectList(wrapper);
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }
}
