package com.bcxin.risk.activity;

import com.bcxin.risk.activity.dto.search.VenueSearchDTO;
import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.domain.Region;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;


@Repository
public class VenueDaoImpl extends DaoImpl<Venue> implements VenueDao{

    @Override
    public Venue getVenueByName(String name) {
        List<Criterion> criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq("name", name));
        Order order = Order.desc("oid");
        List<Venue> list = selectPage(criterionList,null,order);
        if ( CollectionUtil.isEmpty(list) ) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public List<Venue> getStandardVenue(Region province, Region city) {
        List<Criterion> criterionList = Lists.newArrayList();
        SelectWrapper wrapper = SelectWrapper.instance();
        criterionList.add(Restrictions.eq("standard", DictConst.Y));
        if(province != null) {
            criterionList.add(Restrictions.eq("province", province));
        }
        if(city != null) {
            criterionList.add(Restrictions.eq("city", city));
        }
        List list = selectList(criterionList);

        return 	list;
    }

    @Override
    public Venue findVenueByOid(Long oid){
        return selectById(oid);
    }

    @Override
    public List<Venue> findVenueList(VenueSearchDTO searchDto, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        if ( searchDto.getOrg() != null ) {
            wrapper.eq("org", searchDto.getOrg());
        }
        if ( searchDto.getProvince() != null ) {
            wrapper.eq("province", searchDto.getProvince());
        }
        if ( searchDto.getCity() != null ) {
            wrapper.eq("city", searchDto.getCity());
        }
        if ( searchDto.getArea() != null ) {
            wrapper.eq("area", searchDto.getArea());
        }
        if (StringUtil.isNotEmpty(searchDto.getName()) ) {
            wrapper.eq("name", searchDto.getName());
        }
        if (StringUtil.isNotEmpty(searchDto.getStandard()) ) {
            wrapper.eq("standard", searchDto.getStandard());
        }
        if ( page == null ) {
            return selectList(wrapper);
        }
        return selectPage(wrapper,page).getRecords();
    }

}
