package com.bcxin.risk.activity;

import com.bcxin.risk.activity.dto.search.ActivityMaterialSearchDTO;
import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.user.domain.User;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;


/**
 * Created by PVer on 2017/4/24.
 */
@Repository
public class ActivityMaterialDaoImpl extends DaoImpl<ActivityMaterial> implements ActivityMaterialDao{

    @Override
    public ActivityMaterial findActivityMaterialByOid(Long oid){
        return selectById(oid);
    }

    @Override
    public List<ActivityMaterial> findActivityMaterialList(ActivityMaterialSearchDTO searchDto) {
        List<Criterion> criterionList = Lists.newArrayList();
        if ( searchDto.getUser() != null ) {
            criterionList.add(Restrictions.eq("user", searchDto.getUser()));
        }
        if ( searchDto.getActivity() != null ) {
            criterionList.add(Restrictions.eq("activity", searchDto.getActivity()));
        }
        if (StringUtil.isNotEmpty(searchDto.getActivityMaterialType()) ) {
            criterionList.add(Restrictions.eq("activityMaterialType", searchDto.getActivityMaterialType()));
        }
        return selectList(criterionList);
    }

    @Override
    public List<ActivityMaterial> findActivityMaterialByActivity(Activity activity) {
        List<Criterion> criterionList = Lists.newArrayList();
        if (activity != null ) {
            criterionList.add(Restrictions.eq("activity", activity));
        }
        return selectList(criterionList);
    }


    @Override
    public List<ActivityMaterial> findAcMaterialByActivityAndUser(Activity activity, User user) {
        List<Criterion> criterionList = Lists.newArrayList();
        if (activity != null ) {
            criterionList.add(Restrictions.eq("activity", activity));
        }
        if (user != null ) {
            criterionList.add(Restrictions.eq("user", user));
        }
        return selectList(criterionList);
    }

    @Override
    public ActivityMaterial findActivityMaterialByActivity(Activity activity,String materialType) {
        List<Criterion> criterionList = Lists.newArrayList();
        if (activity != null ) {
            criterionList.add(Restrictions.eq("activity", activity));
        }
        if ( StringUtil.isNotEmpty(materialType) ){
            criterionList.add(Restrictions.eq("activityMaterialType", materialType));
        }
        List<ActivityMaterial> list = selectList(criterionList);
        if (CollectionUtil.isNotEmpty(list)){
            return list.get(0);
        }
        return null;
    }

    @Override
    public void mergeActivityMaterial(ActivityMaterial activityMaterial){

        mergeObj(activityMaterial);
    };

    @Override
    public ActivityMaterial findActivityMaterial(ActivityMaterialSearchDTO searchDto){
        List<Criterion> criterionList = Lists.newArrayList();
        if (StringUtil.isNotEmpty(searchDto.getActivityMaterialType()) ){
            criterionList.add(Restrictions.eq("activityMaterialType", searchDto.getActivityMaterialType()));
        }
        if (searchDto.getActivity() != null){
            criterionList.add(Restrictions.eq("activity", searchDto.getActivity()));
        }
        if (searchDto.getUser() != null){
            criterionList.add(Restrictions.eq("user", searchDto.getUser()));
        }
        List<ActivityMaterial> materialList = selectList(criterionList);
        if (CollectionUtil.isNotEmpty(materialList)) {
            return materialList.get(0);
        }
        return null;
    }


    // 查询建立报告是否提交完成
    @Override
    public Map<String,Object> querySubReport(Activity activity){
        long activity_id = activity.getOid();
        String sql = "SELECT (CASE WHEN (SELECT COUNT(1) " +
                                           " FROM risk_activitymaterial " +
                                          " WHERE activitymaterialType = '" + DictConst.ACTIVITYMATERIALTYPE_JLBG_KS +"' "+
                                            " AND activity_id =" + activity_id +") = m.supOrgCount " +
                                  " THEN '1' " +
                                  " ELSE '0' " +
                                  " END ) AS jcb, " +
                            "(CASE WHEN (SELECT COUNT(1) " +
                                           " FROM risk_activitymaterial " +
                                          " WHERE activitymaterialType = '" + DictConst.ACTIVITYMATERIALTYPE_JLBG_JS +"' "+
                                            " AND activity_id =" + activity_id +") = m.supOrgCount " +
                                 " THEN '1' " +
                                 " ELSE '0' " +
                                 " END ) AS jlbg  " +
                      " FROM " + "(SELECT count(1) AS supOrgCount " +
                                    " FROM risk_activity_cooper a,risk_serviceorg b " +
                                   " WHERE a.org_id = b.oid " +
                                     " AND b.serviceOrgType = '" + DictConst.SERVICEORGTYPE_JLGS +"' "+
                                     " AND a.activity_id ="+ activity_id +")m " ;
            SelectWrapper wrapper = SelectWrapper.instance();
             return  queryMap( sql,  wrapper);
    }

    public ActivityMaterial findActivityMaterialByActivityAndType(Activity activity, String approvalMaterial) {
        return null;
    }


    @Override
    public void updateActivityMaterialByDto(ActivityMaterialSearchDTO dto){
        long activity_id = dto.getActivity().getOid();
        String sql = "UPDATE risk_activitymaterial " +
                       " SET commitStatus = '" +dto.getCommitStatus()+"' "+
                     " WHERE activity_id =" + activity_id +
                       " AND activitymaterialType = '" + dto.getActivityMaterialType()+"'" ;
         executeSqlUpdate(sql);
    }
}
