package com.bcxin.risk.activity;

import com.bcxin.risk.activity.dto.search.ActivityApprovalSearchDTO;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public class ActivityApprovalDaoImpl extends DaoImpl<ActivityApproval> implements ActivityApprovalDao{

    @Override
    public ActivityApproval findActivityApprovalByOid(Long oid){
        return selectById(oid);
    }

    @Override
    public List<ActivityApproval> findActivityApprovalList(ActivityApprovalSearchDTO searchDto, Page page) {
        List<Criterion> criterionList = Lists.newArrayList();
        if (StringUtil.isNotEmpty(searchDto.getName()) ) {
            criterionList.add(Restrictions.eq("name", searchDto.getName()));
        }
        if (StringUtil.isNotEmpty(searchDto.getApprovalDate()) ) {
            criterionList.add(Restrictions.eq("approvalDate", searchDto.getApprovalDate()));
        }
        if (StringUtil.isNotEmpty(searchDto.getApprovalName()) ) {
            criterionList.add(Restrictions.eq("approvalName", searchDto.getApprovalName()));
        }
        if (StringUtil.isNotEmpty(searchDto.getApprovalStatus()) ) {
            criterionList.add(Restrictions.eq("approvalStatus", searchDto.getApprovalStatus()));
        }
        if ( page == null ) {
            return selectList(criterionList);
        }
        return selectPage(criterionList,page);
    }

    @Override
    public List<ActivityApproval> findBackList(Activity activity){
        List<Criterion> criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq("activity", activity));
        criterionList.add(Restrictions.in("approvalStatus", new Object[]{"20","SL20","NO","REJECT"}));
        return selectList(criterionList);
    }


}
