package com.bcxin.risk.user.dao;

import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.expert.dto.ExpertPublicDto;
import com.bcxin.risk.hibernateplus.dao.IDao;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.user.domain.ExpertUser;
import com.bcxin.risk.user.domain.User;
import com.bcxin.risk.user.dto.search.ExpertUserSearchDto;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * @author hzp
 * 专家用户DAO层
 */
public interface ExpertUserDao extends IDao<ExpertUser>  {

    /**
     * 根据主键ID获取专家用户实体
     * @param oid 主键ID（用户ID）
     * @return
     */
    ExpertUser findExpertUserByOid(Long oid);

    /**
     * 获取专家用户ID集合
     * @return
     */
    List<String> findComposeExpertUserId();

    /**
     * 根据用户名获取专家用户实体
     * @param name 用户名
     * @return
     */
    ExpertUser findUserByName(String name);

    /**
     * 分页查询
     * @param serachDto 查询传输对象
     * @param page
     * @return
     */
    List<ExpertUser> findExpertUserList(ExpertUserSearchDto serachDto, DwzPage page);

    List<ExpertUser> findUserByOrgIdAndUserType(Long orgId, String userType,String status);

    List<ExpertUser> findUserByOrgIdAndUserTypeAndKTType(Long orgId, String userType, String status, Collection<String> ktType);

    List<ExpertPublicDto> findExpertPublicList(ExpertPublicDto dto, Page page);
}
