package com.bcxin.risk.surveytk;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.hibernateplus.dao.IDao;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.survey.domain.SurveyTask;
import com.bcxin.risk.surveytk.domain.dto.SurveyTaskDataDto;
import com.bcxin.risk.surveytk.domain.dto.SurveyTaskDto;
import com.bcxin.risk.surveytk.enums.SurveyStatusEnum;

import java.util.List;
import java.util.Map;

/**
 * @author hzp
 * 踏勘任务DAO层
 */
public interface SurveyTkTaskDao extends IDao<SurveyTask> {

    /**
     * 根据主键id查找踏勘任务
     * @param oid
     * @return
     */
    SurveyTask findSurveyTaskByOid(Long oid);

    /**
     * 查询踏勘任务列表
     * @param searchDto 查询对象
     * @param page
     * @return
     */
    List<SurveyTaskDataDto> findSurveyTaskList(SurveyTaskDto searchDto, Page page);


    /**
     * 根据任务id获取踏勘任务
     * @param taskId 任务id
     * @param surveyStatusEnum 探勘状态
     * @return
     */
    SurveyTask findSurveyTaskByTaskId(Long taskId, SurveyStatusEnum surveyStatusEnum);

    /**
     * 获取踏勘计划列表
     * @param surveyTaskId
     * @param step 踏勘阶段
     * @param venueId 场馆id
     * @return
     */
    List<Map<String, Object>> findSurveyPlan(Long surveyTaskId,String step,Long venueId);

    /**
     * 获取踏勘整改意见
     * @param questionIds 踏勘计划id集合
     * @return
     */
    List<Map<String, Object>> findSurveySuggest(List<Long> questionIds);

    Long getVenue(Long surveyTaskId,String step);

    boolean checkSurveyExpertAndDoing(Activity activity, String step);

}
