package com.bcxin.risk.survey;

import com.bcxin.risk.compose.dto.data.ComposeTaskDataDto;
import com.bcxin.risk.hibernateplus.dao.IDao;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.survey.domain.SurveyPlan;
import com.bcxin.risk.survey.domain.dto.serach.SurveyPlanSerachDto;

import java.util.List;

public interface SurveyPlanDao extends IDao<SurveyPlan> {

    SurveyPlan  findSurveyPlanByOid(Long oid);

    List<SurveyPlan> findSurveyPlanList(SurveyPlanSerachDto serachDto, Page page);

    ComposeTaskDataDto findSign(Long activity_id);

    /**
     * 根据任务id获取踏勘计划
     * @param taskId
     * @return
     */
    List<SurveyPlan> findSurveyPlanListBySurveyTaskId(Long taskId);

    /**
     * 获取踏勘计划列表(taskId+阶段+场馆)
     * @param taskId
     * @param step
     * @param venueId
     * @return
     */
    List<SurveyPlan> findSurveyPlan(Long taskId,String step,Long venueId);
}
