package com.bcxin.risk.report.material.dao;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.common.dto.data.SurveyReportDto;
import com.bcxin.risk.hibernateplus.dao.IDao;
import com.bcxin.risk.report.domain.Report;

import java.util.List;

/**
 * 报告相关
 *
 * @author Ethan
 */
public interface ReportDao extends IDao<Report> {

    Report findReportByActivity(Activity activity);

    Report getReportByOid(long oid);

    List<SurveyReportDto> getSurveyReportList(Long activityId);


    /**
     * 更新reportId对应的esignflowId值
     * @param reportId oid
     * @param flowId
     * @return
     */
    int updateReportEsignFlowId(long reportId, String flowId);

    /**
     * 根据esignFlowId查找report
     * @param oid
     * @return
     */
    Report getReportByEsignFlowId(String oid);

    List<Object> findReportDetailBySQL(String start_datetime , String end_datetime);

    List<Object> findReportDetailBySQL(String end_datetime);
}
