package com.bcxin.risk.compose.draft;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.compose.dto.data.ComposeTaskDataDto;
import com.bcxin.risk.compose.dto.data.TaskUserDto;
import com.bcxin.risk.compose.dto.search.ComposeTaskSearchDto;
import com.bcxin.risk.hibernateplus.dao.IDao;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.report.domain.Report;
import com.bcxin.risk.user.domain.User;

import java.util.List;
import java.util.Map;

public interface ComposeTaskDao extends IDao<ComposeTask> {

	ComposeTask findById(long id);

	List<ComposeTask> findComposeTaskList(ComposeTaskSearchDto searchDto, Page page);

    List<ComposeTaskDataDto> findAssignComposeTaskList(ComposeTaskSearchDto composeTaskSearchDto , Page page);

    List<ComposeTaskDataDto> findComposeTaskDTOList(ComposeTaskSearchDto composeTaskSearchDto , Page page);

    Map<String,Object> countCompose(User user);

    Map<String, String> countExpertCompose();

    ComposeTaskDataDto findComposeUser(ComposeTaskSearchDto searchDto);

    void backCompose(Long activityId);

    void delete(Long activityId,String taskType);

    void deleteByIds(List<String> ids);

    List<ComposeTask> findDoListByActivityIdAndTaskType(Activity activity, String taskType);

    List<ComposeTask> findByActivity(Activity activity);

    List<ComposeTask> findByActivityAndType(Activity activity,String taskType);

    List<TaskUserDto> findTaskUserByActivity(Activity activity);

    /**
     * 获取专家订单
     * @param composeTaskSearchDto
     * @param page
     * @return
     */
    List<ComposeTaskDataDto> findExpertOrderList(ComposeTaskSearchDto composeTaskSearchDto, Page page);

    /**
     * 统计专家订单
     * @param user
     * @return
     */
    Map<String,Object> countExpertOrder(User user);

    ComposeTask findByActivityAnUser(Activity activity,User user,String taskType);

    void updatePublicExpertStatus(Report report, String taskType, String taskStatus);
}
